/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.rc2;

import com.cryptomathic.crypto.rc2.rc2tbl;

public final class rc2Kernel {
    public static final int[] makekeys(byte[] key, int T1) {
        int i;
        byte[] L = new byte[128];
        int T = key.length;
        System.arraycopy(key, 0, L, 0, T);
        int T8 = T1 + 7 >>> 3;
        int TM = 255 >>> (T8 << 3) - T1;
        for (i = T; i < L.length; ++i) {
            L[i] = rc2tbl.PITABLE[0xFF & L[i - 1] + L[i - T]];
        }
        L[L.length - T8] = rc2tbl.PITABLE[L[L.length - T8] & TM];
        for (i = L.length - 1 - T8; i >= 0; --i) {
            L[i] = (byte)(0xFF & rc2tbl.PITABLE[0xFF & (L[i + 1] ^ L[i + T8])]);
        }
        int[] K = new int[L.length >>> 1];
        for (int i2 = 0; i2 < K.length; ++i2) {
            K[i2] = rc2Kernel.qrunch(L, i2 << 1);
        }
        return K;
    }

    public static final void encrypt(int[] keys, byte[] input, int offset) {
        int[] R = new int[]{rc2Kernel.qrunch(input, offset), rc2Kernel.qrunch(input, offset + 2), rc2Kernel.qrunch(input, offset + 4), rc2Kernel.qrunch(input, offset + 6)};
        rc2Kernel.mixing_round(R, keys, 0);
        rc2Kernel.mixing_round(R, keys, 4);
        rc2Kernel.mixing_round(R, keys, 8);
        rc2Kernel.mixing_round(R, keys, 12);
        rc2Kernel.mixing_round(R, keys, 16);
        rc2Kernel.mashing_round(R, keys);
        rc2Kernel.mixing_round(R, keys, 20);
        rc2Kernel.mixing_round(R, keys, 24);
        rc2Kernel.mixing_round(R, keys, 28);
        rc2Kernel.mixing_round(R, keys, 32);
        rc2Kernel.mixing_round(R, keys, 36);
        rc2Kernel.mixing_round(R, keys, 40);
        rc2Kernel.mashing_round(R, keys);
        rc2Kernel.mixing_round(R, keys, 44);
        rc2Kernel.mixing_round(R, keys, 48);
        rc2Kernel.mixing_round(R, keys, 52);
        rc2Kernel.mixing_round(R, keys, 56);
        rc2Kernel.mixing_round(R, keys, 60);
        rc2Kernel.unqrunch(R[0], input, offset);
        rc2Kernel.unqrunch(R[1], input, offset + 2);
        rc2Kernel.unqrunch(R[2], input, offset + 4);
        rc2Kernel.unqrunch(R[3], input, offset + 6);
    }

    private static final void mixing_round(int[] R, int[] K, int j) {
        R[0] = 0xFFFF & R[0] + K[j] + (R[3] & R[2]) + (~R[3] & R[1]);
        R[0] = 0xFFFF & (R[0] << 1 | R[0] >>> 15);
        R[1] = 0xFFFF & R[1] + K[j + 1] + (R[0] & R[3]) + (~R[0] & R[2]);
        R[1] = 0xFFFF & (R[1] << 2 | R[1] >>> 14);
        R[2] = 0xFFFF & R[2] + K[j + 2] + (R[1] & R[0]) + (~R[1] & R[3]);
        R[2] = 0xFFFF & (R[2] << 3 | R[2] >>> 13);
        R[3] = 0xFFFF & R[3] + K[j + 3] + (R[2] & R[1]) + (~R[2] & R[0]);
        R[3] = 0xFFFF & (R[3] << 5 | R[3] >>> 11);
    }

    private static final void mashing_round(int[] R, int[] K) {
        R[0] = 0xFFFF & R[0] + K[R[3] & 0x3F];
        R[1] = 0xFFFF & R[1] + K[R[0] & 0x3F];
        R[2] = 0xFFFF & R[2] + K[R[1] & 0x3F];
        R[3] = 0xFFFF & R[3] + K[R[2] & 0x3F];
    }

    public static final void decrypt(int[] keys, byte[] input, int offset) {
        int[] R = new int[]{rc2Kernel.qrunch(input, offset), rc2Kernel.qrunch(input, offset + 2), rc2Kernel.qrunch(input, offset + 4), rc2Kernel.qrunch(input, offset + 6)};
        rc2Kernel.reverse_mixing_round(R, keys, 60);
        rc2Kernel.reverse_mixing_round(R, keys, 56);
        rc2Kernel.reverse_mixing_round(R, keys, 52);
        rc2Kernel.reverse_mixing_round(R, keys, 48);
        rc2Kernel.reverse_mixing_round(R, keys, 44);
        rc2Kernel.reverse_mashing_round(R, keys);
        rc2Kernel.reverse_mixing_round(R, keys, 40);
        rc2Kernel.reverse_mixing_round(R, keys, 36);
        rc2Kernel.reverse_mixing_round(R, keys, 32);
        rc2Kernel.reverse_mixing_round(R, keys, 28);
        rc2Kernel.reverse_mixing_round(R, keys, 24);
        rc2Kernel.reverse_mixing_round(R, keys, 20);
        rc2Kernel.reverse_mashing_round(R, keys);
        rc2Kernel.reverse_mixing_round(R, keys, 16);
        rc2Kernel.reverse_mixing_round(R, keys, 12);
        rc2Kernel.reverse_mixing_round(R, keys, 8);
        rc2Kernel.reverse_mixing_round(R, keys, 4);
        rc2Kernel.reverse_mixing_round(R, keys, 0);
        rc2Kernel.unqrunch(R[0], input, offset);
        rc2Kernel.unqrunch(R[1], input, offset + 2);
        rc2Kernel.unqrunch(R[2], input, offset + 4);
        rc2Kernel.unqrunch(R[3], input, offset + 6);
    }

    private static final void reverse_mixing_round(int[] R, int[] K, int j) {
        R[3] = 0xFFFF & (R[3] << 11 | R[3] >>> 5);
        R[3] = 0xFFFF & R[3] - K[j + 3] - (R[2] & R[1]) - (~R[2] & R[0]);
        R[2] = 0xFFFF & (R[2] << 13 | R[2] >>> 3);
        R[2] = 0xFFFF & R[2] - K[j + 2] - (R[1] & R[0]) - (~R[1] & R[3]);
        R[1] = 0xFFFF & (R[1] << 14 | R[1] >>> 2);
        R[1] = 0xFFFF & R[1] - K[j + 1] - (R[0] & R[3]) - (~R[0] & R[2]);
        R[0] = 0xFFFF & (R[0] << 15 | R[0] >>> 1);
        R[0] = 0xFFFF & R[0] - K[j] - (R[3] & R[2]) - (~R[3] & R[1]);
    }

    private static final void reverse_mashing_round(int[] R, int[] K) {
        R[3] = 0xFFFF & R[3] - K[R[2] & 0x3F];
        R[2] = 0xFFFF & R[2] - K[R[1] & 0x3F];
        R[1] = 0xFFFF & R[1] - K[R[0] & 0x3F];
        R[0] = 0xFFFF & R[0] - K[R[3] & 0x3F];
    }

    private static final int qrunch(byte[] b, int boffset) {
        return 0xFFFF & (b[boffset + 1] << 8 | b[boffset] & 0xFF);
    }

    private static final void unqrunch(int value, byte[] b, int boffset) {
        b[boffset] = (byte)(value & 0xFF);
        b[boffset + 1] = (byte)(value >>> 8);
    }
}

