/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.pseudo;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashMech;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import java.math.BigInteger;
import java.util.Random;

public class SHASecureRandom
extends Random {
    private static final int LENGTH = 20;
    private static final int ROUND = 5;
    private static final HashType HASH = HashType.SHA;
    private byte[] _seed = new byte[20];

    public SHASecureRandom() {
        Random random = new Random();
        random.nextBytes(this._seed);
    }

    public SHASecureRandom(byte[] seed) throws NullPointerException {
        if (seed == null) {
            throw new NullPointerException("Seed is null");
        }
        try {
            this._seed = HashMech.hash_mes(HASH, HashPadMode.NOPAD, seed, seed.length);
        }
        catch (HashException e) {
            if (seed.length > 20) {
                System.arraycopy(seed, 0, this._seed, 0, 20);
            }
            System.arraycopy(seed, 0, this._seed, 0, seed.length);
        }
    }

    protected int next(int bits) {
        int ratio = 4;
        try {
            this._seed = HashMech.hash_mes(HASH, HashPadMode.NOPAD, this._seed, this._seed.length);
        }
        catch (HashException e) {
            // empty catch block
        }
        long res = 0L;
        for (int i = 0; i < 5; ++i) {
            int next = 0;
            for (int j = 0; j < ratio; ++j) {
                next = (byte)(next ^ this._seed[i * ratio + j]);
            }
            res = res << 8 ^ (long)next & 0xFFL;
        }
        return (int)(res >>> 40 - bits);
    }

    private synchronized void getBytes(byte[] bytes, int index) throws IndexOutOfBoundsException {
        int ratio = 4;
        if (index >= bytes.length) {
            throw new IndexOutOfBoundsException(index + ">=" + bytes.length);
        }
        int length = bytes.length - index;
        if (length == 0) {
            return;
        }
        if (length > 5) {
            length = 5;
        }
        try {
            this._seed = HashMech.hash_mes(HASH, HashPadMode.NOPAD, this._seed, this._seed.length);
        }
        catch (HashException e) {
            // empty catch block
        }
        for (int i = 0; i < length; ++i) {
            bytes[index + i] = 0;
            for (int j = 0; j < ratio; ++j) {
                int n = index + i;
                bytes[n] = (byte)(bytes[n] ^ this._seed[i * ratio + j]);
            }
        }
    }

    public synchronized void nextBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        int q = bytes.length / 5;
        int r = bytes.length % 5;
        try {
            for (int i = 0; i < q; ++i) {
                this.getBytes(bytes, i * 5);
            }
            if (r > 0) {
                this.getBytes(bytes, q * 5);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println(e.toString());
        }
    }

    public synchronized void setSeed(byte[] newSeed) {
        try {
            this._seed = HashMech.hash_mes(HASH, HashPadMode.NOPAD, newSeed, newSeed.length);
        }
        catch (HashException hashException) {
            // empty catch block
        }
    }

    public synchronized void mixSeed(byte[] seed) {
        try {
            HashState state = HashState.start_hash(HASH);
            state.do_hash(this._seed, 0, this._seed.length);
            this._seed = state.stop_hash(HashPadMode.NOPAD, seed, 0, seed.length);
        }
        catch (HashException hashException) {
            // empty catch block
        }
    }

    public BigInteger nextBigInteger(int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Negative number of bits");
        }
        if (length == 0) {
            return BigInteger.valueOf(0L);
        }
        int no_of_bytes = length / 8;
        int remainder = length % 8;
        byte[] bytes = remainder == 0 ? new byte[no_of_bytes] : new byte[no_of_bytes + 1];
        this.nextBytes(bytes);
        if (remainder == 0) {
            return new BigInteger(1, bytes);
        }
        int blind = 0;
        for (int i = 0; i < remainder; ++i) {
            blind = (byte)(blind << 1);
            blind = (byte)(blind + 1);
        }
        bytes[0] = (byte)(bytes[0] & blind);
        return new BigInteger(1, bytes);
    }
}

