/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.des.DesKeyUtil;
import com.cryptomathic.crypto.provider.SecretKeyDes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class KeyGeneratorDes
extends KeyGeneratorSpi {
    private SecureRandom _sr = null;

    protected void engineInit(SecureRandom sr) {
        this._sr = sr;
    }

    protected void engineInit(AlgorithmParameterSpec aps, SecureRandom sr) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not supported.");
    }

    protected void engineInit(int keysize, SecureRandom sr) {
        throw new InvalidParameterException("Not supported.");
    }

    protected SecretKey engineGenerateKey() {
        SecretKeyDes key;
        if (this._sr == null) {
            Date _now = new Date();
            try {
                this._sr = SecureRandom.getInstance("SHA1PRNG", "Cryptomathic");
                this._sr.setSeed(_now.toString().getBytes());
            }
            catch (Exception ex) {
                this._sr = new SecureRandom();
                this._sr.setSeed(_now.toString().getBytes());
            }
        }
        byte[] newkey = new byte[8];
        boolean strongKeyFound = false;
        while (!strongKeyFound) {
            this._sr.nextBytes(newkey);
            DesKeyUtil.forceOddParity(newkey);
            if (!DesKeyUtil.isKeyStrong(newkey)) continue;
            strongKeyFound = true;
        }
        try {
            key = new SecretKeyDes(newkey);
        }
        catch (InvalidKeyException ike) {
            return null;
        }
        return key;
    }
}

