/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.provider.SecretKey3Des;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;

public class KeyFactory3DES
extends SecretKeyFactorySpi {
    public SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            DESedeKeySpec dks = (DESedeKeySpec)keySpec;
            return new SecretKey3Des(dks.getKey());
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("keySpec must be javax.crypto.spec.DESedeKeySpec");
        }
    }

    public KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (!keySpec.getName().equals("javax.crypto.spec.DESedeKeySpec")) {
                System.out.println(keySpec.getName());
                throw new InvalidKeySpecException("Only javax.crypto.spec.DESedeKeySpec is supported");
            }
            byte[] k = key.getEncoded();
            if (k == null) {
                throw new InvalidKeySpecException("Invalid key. getEncoded returned null");
            }
            if (k.length == 16) {
                byte[] t = new byte[24];
                System.arraycopy(k, 0, t, 0, 16);
                System.arraycopy(k, 0, t, 16, 8);
                return new DESedeKeySpec(t);
            }
            if (k.length == 24) {
                return new DESedeKeySpec(k);
            }
            throw new InvalidKeySpecException("Invalid key. Only supports 16 and 24 byte keys");
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeySpecException(ike.getMessage());
        }
    }

    public SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        byte[] k = key.getEncoded();
        if (k == null || k.length != 16 && k.length != 24) {
            throw new InvalidKeyException("Supports only 16 or 24 bytes key material");
        }
        return new SecretKey3Des(k);
    }
}

