/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.provider.CipherBlockCBCBase;
import com.cryptomathic.crypto.rc2.rc2Kernel;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class CipherRC2CBC
extends CipherBlockCBCBase {
    private int[] exp_key;
    private int ekb;

    public CipherRC2CBC() {
        super(8);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        try {
            this.ekb = key.getEncoded().length * 8;
            this.exp_key = rc2Kernel.makekeys(key.getEncoded(), this.ekb);
        }
        catch (ClassCastException cce) {
            throw new InvalidKeyException("Not a valid RC2 key!");
        }
        this._sran = random;
        this._sran.nextBytes(this._iv);
        this.reset();
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algParam, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not supported");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] temp3;
        RC2ParameterSpec spec;
        this._encrypting = opmode == 1;
        int n = this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        if (params instanceof RC2ParameterSpec) {
            spec = (RC2ParameterSpec)params;
            temp3 = spec.getIV();
            if (temp3 == null || temp3.length != this.BLOCK_SIZE) {
                throw new InvalidAlgorithmParameterException("IV not " + this.BLOCK_SIZE + " bytes");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
        System.arraycopy(temp3, 0, this._iv, 0, this.BLOCK_SIZE);
        this.ekb = spec.getEffectiveKeyBits();
        try {
            this.exp_key = rc2Kernel.makekeys(key.getEncoded(), this.ekb);
        }
        catch (ClassCastException cce) {
            throw new InvalidKeyException("Not a valid RC2 key!");
        }
        this._sran = random;
        this.reset();
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        System.arraycopy(input, ioffset, output, ooffset, this.BLOCK_SIZE);
        rc2Kernel.decrypt(this.exp_key, output, ooffset);
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        System.arraycopy(input, ioffset, output, ooffset, this.BLOCK_SIZE);
        rc2Kernel.encrypt(this.exp_key, output, ooffset);
    }
}

