/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.aes.AesKernel;
import com.cryptomathic.crypto.provider.CipherBlockECBBase;
import com.cryptomathic.crypto.provider.SecretKeyAes;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherAesECB
extends CipherBlockECBBase {
    protected int[][] _round_keys_encrypt;
    protected int[][] _round_keys_decrypt;

    public CipherAesECB() {
        super(16);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        try {
            SecretKeyAes _key = (SecretKeyAes)key;
            this._round_keys_encrypt = AesKernel.makekeys_encrypt_128(_key.getEncoded());
            this._round_keys_decrypt = AesKernel.makekeys_decrypt_128(_key.getEncoded());
        }
        catch (ClassCastException cce) {
            try {
                SecretKeySpec sks = (SecretKeySpec)key;
                byte[] key_material = sks.getEncoded();
                if (key_material == null || key_material.length != 16) {
                    throw new InvalidKeyException("SecretKeySpec does not contain a valid AES key");
                }
                this._round_keys_encrypt = AesKernel.makekeys_encrypt_128(key_material);
                this._round_keys_decrypt = AesKernel.makekeys_decrypt_128(key_material);
            }
            catch (ClassCastException cce2) {
                throw new InvalidKeyException("Not a valid AES key!");
            }
        }
        this._sran = random;
        this._sran.nextBytes(this._iv);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algParam, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        try {
            SecretKeyAes _key = (SecretKeyAes)key;
            this._round_keys_encrypt = AesKernel.makekeys_encrypt_128(_key.getEncoded());
            this._round_keys_decrypt = AesKernel.makekeys_decrypt_128(_key.getEncoded());
        }
        catch (ClassCastException cce) {
            try {
                SecretKeySpec sks = (SecretKeySpec)key;
                byte[] key_material = sks.getEncoded();
                if (key_material == null || key_material.length != 16) {
                    throw new InvalidKeyException("SecretKeySpec does not contain a valid AES key");
                }
                this._round_keys_encrypt = AesKernel.makekeys_encrypt_128(key_material);
                this._round_keys_decrypt = AesKernel.makekeys_decrypt_128(key_material);
            }
            catch (ClassCastException cce2) {
                throw new InvalidKeyException("Not a valid AES key!");
            }
        }
        this._sran = random;
        if (algParam != null) {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
        this._sran.nextBytes(this._iv);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        try {
            SecretKeyAes _key = (SecretKeyAes)key;
            this._round_keys_encrypt = AesKernel.makekeys_encrypt_128(_key.getEncoded());
            this._round_keys_decrypt = AesKernel.makekeys_decrypt_128(_key.getEncoded());
        }
        catch (ClassCastException cce) {
            try {
                SecretKeySpec sks = (SecretKeySpec)key;
                byte[] key_material = sks.getEncoded();
                if (key_material == null || key_material.length != 16) {
                    throw new InvalidKeyException("SecretKeySpec does not contain a valid AES key");
                }
                this._round_keys_encrypt = AesKernel.makekeys_encrypt_128(key_material);
                this._round_keys_decrypt = AesKernel.makekeys_decrypt_128(key_material);
            }
            catch (ClassCastException cce2) {
                throw new InvalidKeyException("Not a valid AES key!");
            }
        }
        this._sran = random;
        if (params == null) {
            this._sran.nextBytes(this._iv);
        } else if (params instanceof IvParameterSpec) {
            IvParameterSpec ivspec = (IvParameterSpec)params;
            byte[] temp = ivspec.getIV();
            if (temp == null || temp.length != this.BLOCK_SIZE) {
                throw new InvalidAlgorithmParameterException("IV not " + this.BLOCK_SIZE + " bytes");
            }
            System.arraycopy(temp, 0, this._iv, 0, this.BLOCK_SIZE);
        } else {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.decrypt_128(this._round_keys_decrypt, input, ioffset, output, ooffset);
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.encrypt_128(this._round_keys_encrypt, input, ioffset, output, ooffset);
    }
}

