/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.primes;

import com.cryptomathic.crypto.primes.EPrimeParameterException;
import com.cryptomathic.crypto.primes.NoPrimeFoundException;
import com.cryptomathic.crypto.primes.PrimeGenerator;
import com.cryptomathic.crypto.pseudo.SHASecureRandom;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;

public class StrongPrimeGenerator
extends PrimeGenerator {
    public BigInteger p;
    public BigInteger r;
    public BigInteger s;
    public BigInteger t;
    private BigInteger TWO = BigInteger.valueOf(2L);

    public StrongPrimeGenerator() {
    }

    public StrongPrimeGenerator(Random random) {
        super(random);
    }

    private static int bitLength(int arg) {
        int retVal = 0;
        if (arg == 0) {
            return 0;
        }
        if (arg < 0) {
            arg = -arg;
        }
        while (arg > 0) {
            arg >>= 1;
            ++retVal;
        }
        return retVal;
    }

    private BigInteger startP(int size, BigInteger start, BigInteger r_, BigInteger s_) {
        BigInteger rs = r_.multiply(s_);
        BigInteger r_invers = r_.modPow(s_.subtract(this.TWO), s_);
        BigInteger s_invers = s_.modPow(r_.subtract(this.TWO), r_);
        BigInteger retVal = s_.multiply(s_invers);
        retVal = retVal.subtract(r_.multiply(r_invers));
        retVal = retVal.mod(rs);
        for (int i = size + 1; i < start.bitLength(); ++i) {
            start.clearBit(i);
        }
        start.setBit(size);
        start.setBit(size - 1);
        start.clearBit(size - 2);
        start.clearBit(size - 3);
        retVal = start.add(retVal.subtract(start).mod(rs));
        return retVal;
    }

    private BigInteger startR(int size, BigInteger start, BigInteger t_) {
        for (int i = size + 1; i < start.bitLength(); ++i) {
            start.clearBit(i);
        }
        start.setBit(size);
        start.clearBit(size - 1);
        start = start.subtract(start.mod(t_)).add(One);
        if (start.bitLength() < size) {
            start.add(t_);
        }
        return start;
    }

    private BigInteger getNumber(int size) {
        BigInteger retVal = new BigInteger(size, this._random);
        while (retVal.bitLength() < size) {
            retVal = retVal.shiftLeft(1);
        }
        return retVal;
    }

    public BigInteger getPrime(int size, byte[] seed, int modP, int resP, BigInteger e) throws EPrimeParameterException {
        if (!StrongPrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        if (seed.length > 0) {
            byte[] oldSeed = new byte[16];
            this._random.nextBytes(oldSeed);
            byte[] newSeed = new byte[seed.length + 16];
            System.arraycopy(seed, 0, newSeed, 0, seed.length);
            System.arraycopy(oldSeed, 0, newSeed, seed.length, 16);
            try {
                ((SHASecureRandom)this._random).setSeed(newSeed);
            }
            catch (ClassCastException ex) {
                try {
                    ((SecureRandom)this._random).setSeed(newSeed);
                }
                catch (ClassCastException exx) {
                    // empty catch block
                }
            }
        }
        BigInteger start = this.getNumber(size);
        return this.getPrime(size, start, modP, resP, e);
    }

    public BigInteger getPrime(int size, BigInteger start, int modP, int resP, BigInteger e) throws EPrimeParameterException {
        if (!StrongPrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        try {
            if (!e.testBit(0)) {
                throw new EPrimeParameterException("Required exponent is even");
            }
        }
        catch (NullPointerException ex) {
            e = BigInteger.valueOf(1L);
        }
        int size_r = (size - StrongPrimeGenerator.bitLength(size) - 2) / 2 - 2;
        int size_t = size_r - StrongPrimeGenerator.bitLength(size_r) - 2;
        this.t = super.getPrime(size_t, 2, 1);
        boolean foundR = false;
        int size_s = size_r;
        while (!foundR) {
            try {
                BigInteger start_r = this.startR(size_r, this.getNumber(size_r), this.t);
                this.r = this.getPrime(size_r, start_r, this.t, 2, 1, One);
                foundR = true;
            }
            catch (NoPrimeFoundException ex) {
                ++size_r;
            }
        }
        this.s = this.getPrime(size_s, 2, 1);
        try {
            BigInteger step_p = this.r.multiply(this.s);
            BigInteger start_p = this.startP(size, start, this.r, this.s);
            this.p = this.getPrime(size, start_p, step_p, modP, resP, e);
            return this.p;
        }
        catch (NoPrimeFoundException ex) {
            start = start.shiftLeft(1);
            return this.getPrime(size + 1, start, modP, resP, e);
        }
    }

    public BigInteger getPrime(BigInteger start, int modP, int resP, BigInteger e) throws EPrimeParameterException {
        return this.getPrime(start.bitLength(), start, modP, resP, e);
    }
}

