/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.primes;

import com.cryptomathic.crypto.primes.EPrimeParameterException;
import com.cryptomathic.crypto.primes.NoPrimeFoundException;
import com.cryptomathic.crypto.primes.Primality;
import java.math.BigInteger;
import java.util.Random;

public class PrimeGenerator {
    protected static BigInteger One = BigInteger.valueOf(1L);
    protected Random _random;
    private Primality _primality;
    private static int BASELENGTH = 15;
    private static int[] base = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47};
    private int[] rem;
    private int[] steps;

    public PrimeGenerator() {
        this._random = new Random();
        this._primality = new Primality(this._random);
    }

    public PrimeGenerator(Random random) {
        this._random = random;
        this._primality = new Primality(this._random);
    }

    protected BigInteger getPrime(int size, BigInteger start, BigInteger step, int modP, int resP, BigInteger e) throws EPrimeParameterException, NoPrimeFoundException {
        if (!PrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        if (!e.testBit(0)) {
            throw new EPrimeParameterException("Required exponent is even");
        }
        boolean foundStart = false;
        BigInteger bigModP = BigInteger.valueOf(modP);
        BigInteger bigResP = BigInteger.valueOf(resP);
        for (int i = 0; i < modP && !foundStart; ++i) {
            if (bigResP.equals(start.mod(bigModP))) {
                foundStart = true;
                continue;
            }
            start = start.add(step);
        }
        if (!foundStart) {
            throw new EPrimeParameterException("Start and step parameters do not match modP and resP");
        }
        while (step.remainder(bigModP).bitLength() != 0) {
            step = step.shiftLeft(1);
        }
        this.initialiseArrays(start, step);
        start = this.nextCandidate(start, step, e);
        while (!this._primality.isProbablePrime(start) && start.bitLength() == size) {
            start = this.nextCandidate(start, step, e);
        }
        if (start.bitLength() != size) {
            throw new NoPrimeFoundException();
        }
        return start;
    }

    public BigInteger getPrime(int size, int modP, int resP) throws EPrimeParameterException {
        return this.getPrime(size, modP, resP, One);
    }

    public BigInteger getPrime(int size, int modP, int resP, BigInteger e) throws EPrimeParameterException {
        if (!PrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        if (!e.testBit(0)) {
            throw new EPrimeParameterException("Required exponent is even");
        }
        BigInteger step = BigInteger.valueOf(modP);
        BigInteger bigResP = BigInteger.valueOf(resP);
        BigInteger start = this.getStart(size, step, bigResP);
        try {
            return this.getPrime(size, start, step, modP, resP, e);
        }
        catch (NoPrimeFoundException ex) {
            return this.getPrime(size, modP, resP, e);
        }
    }

    public BigInteger getPrime(BigInteger seed, int modP, int resP) throws EPrimeParameterException {
        return this.getPrime(seed, modP, resP, One);
    }

    public BigInteger getPrime(BigInteger seed, int modP, int resP, BigInteger e) throws EPrimeParameterException {
        if (!PrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        try {
            if (!e.testBit(0)) {
                throw new EPrimeParameterException("Required exponent is even");
            }
        }
        catch (NullPointerException ex) {
            e = BigInteger.valueOf(1L);
        }
        BigInteger step = BigInteger.valueOf(modP);
        BigInteger bigResP = BigInteger.valueOf(resP);
        BigInteger start = this.getStart(seed, step, bigResP);
        boolean foundPrime = false;
        int length = seed.bitLength();
        while (!foundPrime) {
            try {
                return this.getPrime(length, start, step, modP, resP, e);
            }
            catch (NoPrimeFoundException ex) {
                ++length;
            }
        }
        return One;
    }

    private BigInteger getStart(int size, BigInteger bigModP, BigInteger bigResP) {
        BigInteger start = new BigInteger(size, this._random);
        if (start.bitLength() < size) {
            start = start.setBit(size - 1);
        }
        if ((start = this.getStart(start, bigModP, bigResP)).bitLength() != size) {
            return this.getStart(size, bigModP, bigResP);
        }
        return start;
    }

    private BigInteger getStart(BigInteger seed, BigInteger bigModP, BigInteger bigResP) {
        BigInteger temp = seed.mod(bigModP);
        return seed.add(bigResP.subtract(temp));
    }

    private BigInteger nextCandidate(BigInteger start, BigInteger step, BigInteger e) {
        try {
            while ((start = this.nextSimpleCandidate(start, step)).remainder(e).compareTo(One) == 0) {
            }
        }
        catch (ArithmeticException ex) {
            return null;
        }
        return start;
    }

    public static boolean validateResP(int modP, int resP) {
        if (modP != 2 && modP != 4 && modP != 8 && modP != 16) {
            return false;
        }
        return 0 < resP && resP < modP && resP % 2 == 1;
    }

    private void initialiseArrays(BigInteger start, BigInteger step) {
        this.rem = new int[BASELENGTH];
        this.steps = new int[BASELENGTH];
        for (int i = 0; i < BASELENGTH; ++i) {
            this.rem[i] = start.remainder(BigInteger.valueOf(base[i])).intValue();
            this.steps[i] = step.remainder(BigInteger.valueOf(base[i])).intValue();
        }
    }

    private boolean updateRemainders() {
        int i;
        boolean foundDivisor = false;
        for (i = 0; i < BASELENGTH; ++i) {
            int n = i;
            this.rem[n] = this.rem[n] + this.steps[i];
        }
        for (i = 0; !foundDivisor && i < BASELENGTH; ++i) {
            int n = i;
            this.rem[n] = this.rem[n] % base[i];
            foundDivisor = this.rem[i] == 0;
        }
        return foundDivisor;
    }

    private BigInteger nextSimpleCandidate(BigInteger start, BigInteger step) {
        start = start.add(step);
        while (this.updateRemainders()) {
            start = start.add(step);
        }
        return start;
    }
}

