/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.primes;

import java.math.BigInteger;
import java.util.Random;

public class Primality {
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private static BigInteger TWO = BigInteger.valueOf(2L);
    private Random _random;
    private int _defaultCertainty = 5;

    public Primality() {
        this._random = new Random();
    }

    public Primality(Random random) {
        this._random = random;
    }

    public boolean isProbablePrime(BigInteger arg) {
        return this.isProbablePrime(arg, this._defaultCertainty);
    }

    public boolean isProbablePrime(BigInteger arg, int certainty) {
        boolean composite = false;
        boolean stopBase = false;
        BigInteger THREE = BigInteger.valueOf(3L);
        if (arg.equals(ONE)) {
            return false;
        }
        if (arg.equals(TWO)) {
            return true;
        }
        if (arg.equals(THREE)) {
            return true;
        }
        if (arg.equals(BigInteger.valueOf(5L))) {
            return true;
        }
        if (arg.equals(BigInteger.valueOf(7L))) {
            return true;
        }
        BigInteger arg_1 = arg.subtract(ONE);
        if (arg.getLowestSetBit() != 0) {
            return false;
        }
        int s = arg_1.getLowestSetBit();
        if (s == 0) {
            return false;
        }
        BigInteger argOdd = arg_1.shiftRight(s);
        BigInteger base = TWO;
        for (int i = 0; i <= certainty && !composite; ++i) {
            BigInteger argTest = base.modPow(argOdd, arg);
            stopBase = argTest.equals(ONE);
            for (int j = 0; j < s && !stopBase; ++j) {
                stopBase = argTest.add(ONE).equals(arg);
                if (stopBase) continue;
                argTest = argTest.multiply(argTest);
                argTest = argTest.remainder(arg);
            }
            if (!stopBase) {
                composite = true;
                continue;
            }
            if (i >= certainty) continue;
            do {
                base = new BigInteger(arg.bitLength(), this._random);
            } while ((base = base.remainder(arg)).compareTo(THREE) == -1 || base.compareTo(arg_1) == 0);
        }
        return !composite;
    }
}

