/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal.keygeneration;

import com.cryptomathic.crypto.minimal.PrimeInt;

public class PrimeIntPlus
extends PrimeInt {
    public static PrimeInt modInverse(PrimeInt a, PrimeInt m) {
        int size = a.wordLength > m.wordLength ? a.wordLength + 2 : m.wordLength + 2;
        PrimeInt w0 = new PrimeInt(size);
        PrimeInt w1 = new PrimeInt(size);
        PrimeInt w2 = new PrimeInt(size);
        PrimeInt r0 = new PrimeInt(size);
        PrimeInt r1 = new PrimeInt(size);
        PrimeInt r2 = new PrimeInt(size);
        PrimeInt q = new PrimeInt(size);
        int sgn_w2 = 1;
        w0.wordLength = 0;
        w1.wordLength = 1;
        w1.value[0] = 1;
        PrimeIntPlus.copyvalue(m, r0);
        PrimeIntPlus.copyvalue(a, r1);
        while (r1.wordLength != 0) {
            PrimeIntPlus.copyvalue(r0, r2);
            PrimeIntPlus.div(r2, r1, q);
            PrimeIntPlus.mult(q, w1, w2);
            PrimeIntPlus.add(w2, w0, w2);
            PrimeIntPlus.div(w2, m, q);
            sgn_w2 = -sgn_w2;
            PrimeIntPlus.copyvalue(r1, r0);
            PrimeIntPlus.copyvalue(r2, r1);
            PrimeIntPlus.copyvalue(w1, w0);
            PrimeIntPlus.copyvalue(w2, w1);
        }
        if (r0.wordLength != 1 || r0.value[0] != 1) {
            throw new ArithmeticException("Not invertible");
        }
        if (sgn_w2 == 1) {
            return m.subtract(w0);
        }
        return w0;
    }

    public static int getLowestSetBit(PrimeInt a) {
        int ints;
        for (ints = 0; ints < a.wordLength && a.value[ints] == 0; ++ints) {
        }
        int bits = 0;
        int s = a.value[ints];
        while (bits < 32 && (s & 1) == 0) {
            ++bits;
            s >>>= 1;
        }
        return ints * 32 + bits;
    }

    public static PrimeInt shiftRight(PrimeInt a, int n) {
        PrimeInt res = new PrimeInt(a);
        res.shr(n);
        return res;
    }

    public static PrimeInt shiftLeft(PrimeInt a, int n) {
        PrimeInt res = new PrimeInt(a.wordLength + (n + 32 - 1) / 32);
        System.arraycopy(a.value, 0, res.value, 0, a.wordLength);
        res.wordLength = a.wordLength + (n + 32 - 1) / 32;
        res.shl(n);
        return res;
    }

    public static PrimeInt setBit(PrimeInt a, int i) {
        if (i < 0) {
            throw new ArithmeticException("Negative address");
        }
        PrimeInt res = a;
        res.expand(i / 32);
        int n = i / 32;
        res.value[n] = res.value[n] | 1 << i % 32;
        return res;
    }

    public static boolean testBit(PrimeInt a, int i) {
        if (i < 0) {
            throw new ArithmeticException("Negative address");
        }
        if (i / 32 >= a.wordLength) {
            return false;
        }
        return (a.value[i / 32] & 1 << i % 32) != 0;
    }
}

