/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal.keygeneration;

import com.cryptomathic.crypto.minimal.PrimeInt;
import com.cryptomathic.crypto.minimal.keygeneration.EPrimeParameterException;
import com.cryptomathic.crypto.minimal.keygeneration.NoPrimeFoundException;
import com.cryptomathic.crypto.minimal.keygeneration.Primality;
import com.cryptomathic.crypto.minimal.keygeneration.PrimeIntPlus;
import java.util.Random;

public class PrimeGenerator {
    protected static PrimeInt One = PrimeInt.valueOf(1);
    protected Random _random;
    private Primality _primality;
    private static int BASELENGTH = 15;
    private static int[] base = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47};
    private int[] rem;
    private int[] steps;

    public PrimeGenerator() {
        this._random = new Random();
        this._primality = new Primality(this._random);
    }

    public PrimeGenerator(Random random) {
        this._random = random;
        this._primality = new Primality(this._random);
    }

    protected PrimeInt getPrime(int size, PrimeInt start, PrimeInt step, int modP, int resP, PrimeInt e) throws EPrimeParameterException, NoPrimeFoundException {
        if (!PrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        if (!PrimeIntPlus.testBit(e, 0)) {
            throw new EPrimeParameterException("Required exponent is even");
        }
        boolean foundStart = false;
        PrimeInt bigModP = PrimeInt.valueOf(modP);
        PrimeInt bigResP = PrimeInt.valueOf(resP);
        for (int i = 0; i < modP && !foundStart; ++i) {
            if (bigResP.equals(start.mod(bigModP))) {
                foundStart = true;
                continue;
            }
            start = start.add(step);
        }
        if (!foundStart) {
            throw new EPrimeParameterException("Start and step parameters do not match modP and resP");
        }
        while (step.remainder(bigModP).bitLength() != 0) {
            step = PrimeIntPlus.shiftLeft(step, 1);
        }
        this.initialiseArrays(start, step);
        start = this.nextCandidate(start, step, e);
        while (!this._primality.isProbablePrime(start) && start.bitLength() == size) {
            start = this.nextCandidate(start, step, e);
        }
        if (start.bitLength() != size) {
            throw new NoPrimeFoundException();
        }
        return start;
    }

    public PrimeInt getPrime(int size, int modP, int resP) throws EPrimeParameterException {
        return this.getPrime(size, modP, resP, One);
    }

    public PrimeInt getPrime(int size, int modP, int resP, PrimeInt e) throws EPrimeParameterException {
        if (!PrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        if (!PrimeIntPlus.testBit(e, 0)) {
            throw new EPrimeParameterException("Required exponent is even");
        }
        PrimeInt step = PrimeInt.valueOf(modP);
        PrimeInt bigResP = PrimeInt.valueOf(resP);
        PrimeInt res = null;
        do {
            PrimeInt start = this.getStart(size, step, bigResP);
            try {
                res = this.getPrime(size, start, step, modP, resP, e);
            }
            catch (NoPrimeFoundException ex) {
                // empty catch block
            }
        } while (res == null);
        return res;
    }

    public PrimeInt getPrime(PrimeInt seed, int modP, int resP) throws EPrimeParameterException {
        return this.getPrime(seed, modP, resP, One);
    }

    public PrimeInt getPrime(PrimeInt seed, int modP, int resP, PrimeInt e) throws EPrimeParameterException {
        if (!PrimeGenerator.validateResP(modP, resP)) {
            throw new EPrimeParameterException("Invalid value of required residue: " + resP + " modulo " + modP);
        }
        try {
            if (!PrimeIntPlus.testBit(e, 0)) {
                throw new EPrimeParameterException("Required exponent is even");
            }
        }
        catch (NullPointerException ex) {
            e = PrimeInt.valueOf(1);
        }
        PrimeInt step = PrimeInt.valueOf(modP);
        PrimeInt bigResP = PrimeInt.valueOf(resP);
        PrimeInt start = this.getStart(seed, step, bigResP);
        boolean foundPrime = false;
        int length = seed.bitLength();
        while (!foundPrime) {
            try {
                return this.getPrime(length, start, step, modP, resP, e);
            }
            catch (NoPrimeFoundException ex) {
                ++length;
            }
        }
        return One;
    }

    private PrimeInt getStart(int size, PrimeInt bigModP, PrimeInt bigResP) {
        PrimeInt start;
        do {
            if ((start = new PrimeInt(size, this._random)).bitLength() >= size) continue;
            start = PrimeIntPlus.setBit(start, size - 1);
        } while ((start = this.getStart(start, bigModP, bigResP)).bitLength() != size);
        return start;
    }

    private PrimeInt getStart(PrimeInt seed, PrimeInt bigModP, PrimeInt bigResP) {
        PrimeInt temp = seed.mod(bigModP);
        return seed.add(bigResP.subtract(temp));
    }

    private PrimeInt nextCandidate(PrimeInt start, PrimeInt step, PrimeInt e) {
        try {
            while ((start = this.nextSimpleCandidate(start, step)).remainder(e).compareTo(One) == 0) {
            }
        }
        catch (ArithmeticException ex) {
            return null;
        }
        return start;
    }

    public static boolean validateResP(int modP, int resP) {
        if (modP != 2 && modP != 4 && modP != 8 && modP != 16) {
            return false;
        }
        return 0 < resP && resP < modP && resP % 2 == 1;
    }

    private void initialiseArrays(PrimeInt start, PrimeInt step) {
        this.rem = new int[BASELENGTH];
        this.steps = new int[BASELENGTH];
        for (int i = 0; i < BASELENGTH; ++i) {
            this.rem[i] = start.remainder(PrimeInt.valueOf(base[i])).intValue();
            this.steps[i] = step.remainder(PrimeInt.valueOf(base[i])).intValue();
        }
    }

    private boolean updateRemainders() {
        int i;
        boolean foundDivisor = false;
        for (i = 0; i < BASELENGTH; ++i) {
            int n = i;
            this.rem[n] = this.rem[n] + this.steps[i];
        }
        for (i = 0; !foundDivisor && i < BASELENGTH; ++i) {
            int n = i;
            this.rem[n] = this.rem[n] % base[i];
            foundDivisor = this.rem[i] == 0;
        }
        return foundDivisor;
    }

    private PrimeInt nextSimpleCandidate(PrimeInt start, PrimeInt step) {
        start = start.add(step);
        while (this.updateRemainders()) {
            start = start.add(step);
        }
        return start;
    }
}

