/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import com.cryptomathic.crypto.minimal.Convert;

public final class SHA1 {
    private static int h0 = 1732584193;
    private static int h1 = -271733879;
    private static int h2 = -1732584194;
    private static int h3 = 271733878;
    private static int h4 = -1009589776;
    private static int H0;
    private static int H1;
    private static int H2;
    private static int H3;
    private static int H4;

    public static byte[] digest(byte[] mes) {
        int i;
        H0 = h0;
        H1 = h1;
        H2 = h2;
        H3 = h3;
        H4 = h4;
        int full_blocks_part_one = mes.length / 64;
        int full_blocks_part_one_length = full_blocks_part_one * 64;
        int tail = mes.length - full_blocks_part_one_length;
        byte[] tail_block = new byte[tail < 56 ? 64 : 128];
        for (i = 0; i < tail; ++i) {
            tail_block[i] = mes[full_blocks_part_one_length + i];
        }
        tail_block[tail] = -128;
        for (i = tail + 1; i < tail_block.length - 4; ++i) {
            tail_block[i] = 0;
        }
        Convert.bendian_int2byte(tail_block, tail_block.length - 4, 8 * mes.length);
        for (i = 0; i < full_blocks_part_one; ++i) {
            SHA1.hash(mes, i * 64);
        }
        SHA1.hash(tail_block, 0);
        if (tail_block.length == 128) {
            SHA1.hash(tail_block, 64);
        }
        byte[] res = new byte[20];
        Convert.bendian_int2byte(res, 0, H0);
        Convert.bendian_int2byte(res, 4, H1);
        Convert.bendian_int2byte(res, 8, H2);
        Convert.bendian_int2byte(res, 12, H3);
        Convert.bendian_int2byte(res, 16, H4);
        return res;
    }

    private static void hash(byte[] mes, int offset) {
        int tmp;
        int j;
        int i;
        int[] w = new int[80];
        for (i = 0; i < 16; ++i) {
            w[i] = Convert.bendian_byte2int(mes, 4 * i + offset);
        }
        for (i = 16; i < 80; ++i) {
            w[i] = w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16];
            w[i] = w[i] << 1 | w[i] >>> 31;
        }
        int A = H0;
        int B = H1;
        int C = H2;
        int D = H3;
        int E = H4;
        for (j = 0; j < 20; ++j) {
            tmp = (int)((long)((A << 5 | A >>> 27) + (D ^ B & (C ^ D)) + E) + 1518500249L + (long)w[j]);
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = tmp;
        }
        for (j = 20; j < 40; ++j) {
            tmp = (int)((long)((A << 5 | A >>> 27) + (B ^ C ^ D) + E) + 1859775393L + (long)w[j]);
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = tmp;
        }
        for (j = 40; j < 60; ++j) {
            tmp = (int)((long)((A << 5 | A >>> 27) + (B & C | D & (B | C)) + E) + 2400959708L + (long)w[j]);
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = tmp;
        }
        for (j = 60; j < 80; ++j) {
            tmp = (int)((long)((A << 5 | A >>> 27) + (B ^ C ^ D) + E) + 3395469782L + (long)w[j]);
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = tmp;
        }
        H0 += A;
        H1 += B;
        H2 += C;
        H3 += D;
        H4 += E;
    }
}

