/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import com.cryptomathic.crypto.minimal.BadPasswordException;
import com.cryptomathic.crypto.minimal.BigIntegerExp;
import com.cryptomathic.crypto.minimal.DESede_CBC_decrypt;
import com.cryptomathic.crypto.minimal.ISO9796;
import com.cryptomathic.crypto.minimal.MDC4;
import com.cryptomathic.crypto.minimal.PrimeExp;
import com.cryptomathic.crypto.minimal.PrimeInt;
import com.cryptomathic.crypto.minimal.SHA1;
import java.math.BigInteger;

public final class RSAPrivateKey {
    public byte[] p;
    public byte[] q;
    private byte[] q1p;
    private byte[] p1q;
    private byte[] dp;
    private byte[] dq;
    private boolean UseBigInteger = RSAPrivateKey.bigIntegerCheck();
    public static String VERSION = "Cryptomathic A/S Minimal Crypto v1.0.2";
    private static String error_file = "Invalid file format";

    public RSAPrivateKey(byte[] encryptedkey, byte[] password) throws BadPasswordException {
        byte[] key1 = new byte[8];
        byte[] key2 = new byte[8];
        byte[] c = SHA1.digest(password);
        System.arraycopy(c, 0, key1, 0, 8);
        System.arraycopy(c, 8, key2, 0, 8);
        if (encryptedkey.length < 485) {
            throw new IllegalArgumentException(error_file);
        }
        int file_version = RSAPrivateKey.to_int(encryptedkey, 8, 2);
        if (file_version != 3 && file_version != 4) {
            throw new IllegalArgumentException(error_file);
        }
        int priv_key_offset = RSAPrivateKey.to_int(encryptedkey, 26, 2);
        int priv_key_length = RSAPrivateKey.to_int(encryptedkey, 28, 2);
        if (priv_key_length != 398) {
            throw new IllegalArgumentException(error_file);
        }
        int part_size = RSAPrivateKey.to_int(encryptedkey, priv_key_offset + 2, 2);
        if (part_size != 64) {
            throw new IllegalArgumentException(error_file);
        }
        byte[] iv = new byte[8];
        byte[] priv_key = DESede_CBC_decrypt.decrypt(key1, key2, RSAPrivateKey.array_copy(encryptedkey, priv_key_offset + 6, priv_key_length - 8 - 6));
        this.p = RSAPrivateKey.invBytes(RSAPrivateKey.array_copy(priv_key, part_size * 0, part_size));
        this.q = RSAPrivateKey.invBytes(RSAPrivateKey.array_copy(priv_key, part_size * 1, part_size));
        this.q1p = RSAPrivateKey.invBytes(RSAPrivateKey.array_copy(priv_key, part_size * 2, part_size));
        this.p1q = RSAPrivateKey.invBytes(RSAPrivateKey.array_copy(priv_key, part_size * 3, part_size));
        this.dp = RSAPrivateKey.invBytes(RSAPrivateKey.array_copy(priv_key, part_size * 4, part_size));
        this.dq = RSAPrivateKey.invBytes(RSAPrivateKey.array_copy(priv_key, part_size * 5, part_size));
        if (!this.verifyKey()) {
            throw new BadPasswordException();
        }
    }

    public RSAPrivateKey(byte[] p, byte[] q, byte[] q1p, byte[] p1q, byte[] dp, byte[] dq) {
        this.p = p;
        this.q = q;
        this.q1p = q1p;
        this.p1q = p1q;
        this.dp = dp;
        this.dq = dq;
    }

    public byte[] sign(byte[] message) {
        byte[] sign = ISO9796.sign(this, MDC4.digest(message));
        if (sign.length < 128) {
            byte[] temp = new byte[128];
            System.arraycopy(sign, 0, temp, 128 - sign.length, sign.length);
            sign = temp;
        }
        return sign;
    }

    public byte[] exp(byte[] ir) {
        if (this.UseBigInteger) {
            return BigIntegerExp.exp(this.p, this.q, this.q1p, this.p1q, this.dp, this.dq, ir);
        }
        return PrimeExp.exp(this.p, this.q, this.q1p, this.p1q, this.dp, this.dq, ir);
    }

    public byte[] getModulus() {
        if (this.UseBigInteger) {
            return BigIntegerExp.getModulus(this.p, this.q);
        }
        return PrimeExp.getModulus(this.p, this.q);
    }

    public int getModulusbitLength() {
        if (this.UseBigInteger) {
            return BigIntegerExp.getModulusbitLength(this.p, this.q);
        }
        return PrimeExp.getModulusbitLength(this.p, this.q);
    }

    public byte[] getModulusCFPKR() {
        byte[] buffer = new byte[680];
        byte[] b = this.getModulus();
        if (b[0] == 0) {
            b = RSAPrivateKey.array_copy(b, 1, b.length - 1);
        }
        int mod_length = b.length;
        boolean exp_length = true;
        int j = mod_length % 64;
        int aux1 = (mod_length - j) / 2;
        int aux2 = 32 + (mod_length - j);
        byte[] baux = new byte[]{1, 1, 32, 0, (byte)aux1, (byte)aux2, 0, 1, 3};
        System.arraycopy(baux, 0, buffer, 8, 8);
        System.arraycopy(b, j, buffer, 32, mod_length - j);
        for (int i = 0; i < 8; ++i) {
            buffer[i] = buffer[99 - i];
        }
        System.arraycopy(baux, 8, buffer, 33 + (mod_length - j), 1);
        return buffer;
    }

    public static boolean bigIntegerCheck() {
        try {
            BigInteger b = new BigInteger("42");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public byte[] encode() {
        byte[] plaintext = new byte[384];
        RSAPrivateKey.invCopy(this.p, 0, plaintext, 0, 64);
        RSAPrivateKey.invCopy(this.q, 0, plaintext, 64, 64);
        RSAPrivateKey.invCopy(this.q1p, 0, plaintext, 128, 64);
        RSAPrivateKey.invCopy(this.p1q, 0, plaintext, 192, 64);
        RSAPrivateKey.invCopy(this.dp, 0, plaintext, 256, 64);
        RSAPrivateKey.invCopy(this.dq, 0, plaintext, 320, 64);
        return plaintext;
    }

    private static final byte[] array_copy(byte[] data, int offset, int size) {
        byte[] temp = new byte[size];
        System.arraycopy(data, offset, temp, 0, temp.length);
        return temp;
    }

    private static final int to_int(byte[] data, int offset, int size) {
        int result = 0;
        do {
            result |= (data[offset + --size] & 0xFF) << size * 8;
        } while (size > 0);
        return result;
    }

    private static final byte[] invBytes(byte[] data) {
        byte[] temp = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            temp[i] = data[data.length - 1 - i];
        }
        return temp;
    }

    private static final void invCopy(byte[] src, int src_off, byte[] dest, int dest_off, int length) {
        for (int i = 0; i < length; ++i) {
            dest[i + dest_off] = src[src_off + length - 1 - i];
        }
    }

    public boolean verifyKey() {
        if (this.UseBigInteger) {
            BigInteger Big_p = new BigInteger(1, this.p);
            BigInteger Big_q = new BigInteger(1, this.q);
            BigInteger Big_q1p = new BigInteger(1, this.q1p);
            BigInteger Big_p1q = new BigInteger(1, this.p1q);
            BigInteger Big_dp = new BigInteger(1, this.dp);
            BigInteger Big_dq = new BigInteger(1, this.dq);
            BigInteger ONE = BigInteger.valueOf(1L);
            BigInteger Big_e = BigInteger.valueOf(3L);
            BigInteger test = Big_p.multiply(Big_p1q).mod(Big_q);
            if (!test.equals(ONE)) {
                return false;
            }
            test = Big_q.multiply(Big_q1p).mod(Big_p);
            if (!test.equals(ONE)) {
                return false;
            }
            BigInteger p_minus_one = Big_p.subtract(ONE);
            BigInteger test2 = Big_e.multiply(Big_dp).mod(p_minus_one);
            if (!test2.equals(ONE)) {
                return false;
            }
            BigInteger q_minus_one = Big_q.subtract(ONE);
            test2 = Big_e.multiply(Big_dq).mod(q_minus_one);
            return test2.equals(ONE);
        }
        PrimeInt pi_p = new PrimeInt(this.p);
        PrimeInt pi_q = new PrimeInt(this.q);
        PrimeInt pi_q1p = new PrimeInt(this.q1p);
        PrimeInt pi_p1q = new PrimeInt(this.p1q);
        PrimeInt pi_dp = new PrimeInt(this.dp);
        PrimeInt pi_dq = new PrimeInt(this.dq);
        PrimeInt ONE = new PrimeInt(1);
        PrimeInt pi_e = new PrimeInt(3);
        PrimeInt test = pi_p.multiply(pi_dp).mod(pi_q);
        if (!test.equals(ONE)) {
            return false;
        }
        test = pi_q.multiply(pi_dq).mod(pi_p);
        if (!test.equals(ONE)) {
            return false;
        }
        PrimeInt p_minus_one = pi_p.subtract(ONE);
        PrimeInt test3 = pi_e.multiply(pi_dp).mod(p_minus_one);
        if (!test3.equals(ONE)) {
            return false;
        }
        PrimeInt q_minus_one = pi_q.subtract(ONE);
        test3 = pi_e.multiply(pi_dq).mod(q_minus_one);
        return test3.equals(ONE);
    }
}

