/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import java.util.Random;

public class PrimeInt {
    private static final int ADDRESS_BITS_PER_UNIT = 5;
    public static final int BITS_PER_UNIT = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final int TOPMASK = Integer.MIN_VALUE;
    public int[] value;
    public int wordLength;
    private static final long mask = 0xFFFFFFFFL;
    private static final int MAX16 = 65535;

    public PrimeInt() {
        this(128);
    }

    public PrimeInt(byte[] bytes) {
        this((bytes.length * 8 + 32 - 1) / 32);
        this.wordLength = (bytes.length * 8 + 32 - 1) / 32;
        int i = bytes.length - 1;
        int j = 0;
        int shiftby = 0;
        while (i >= 0) {
            int n = j / 4;
            this.value[n] = (int)((long)this.value[n] | (long)(bytes[i] & 0xFF) << shiftby);
            --i;
            ++j;
            shiftby = (shiftby + 8) % 32;
        }
        this.trim();
    }

    public PrimeInt(PrimeInt p) {
        this.value = new int[p.value.length];
        this.wordLength = p.wordLength;
        System.arraycopy(p.value, 0, this.value, 0, p.value.length);
    }

    public byte[] toByteArray() {
        int skip;
        byte[] res = new byte[this.wordLength * 32 / 8];
        int i = this.wordLength * 32 / 8 - 1;
        int j = 0;
        int shiftby = 0;
        while (i >= 0) {
            res[i] = (byte)(this.value[j / 4] >> shiftby & 0xFF);
            --i;
            ++j;
            shiftby = (shiftby + 8) % 32;
        }
        for (skip = 0; skip < res.length && res[skip] == 0; ++skip) {
        }
        byte[] trimmedres = new byte[res.length - skip];
        System.arraycopy(res, skip, trimmedres, 0, trimmedres.length);
        return trimmedres;
    }

    protected static void add(PrimeInt a, PrimeInt b, PrimeInt c) {
        int x1;
        int i;
        PrimeInt L = null;
        PrimeInt S = null;
        if (a.wordLength >= b.wordLength) {
            L = a;
            S = b;
        } else {
            L = b;
            S = a;
        }
        c.wordLength = L.wordLength;
        int kc = 0;
        for (i = 0; i < S.wordLength; ++i) {
            x1 = L.value[i] + kc;
            kc = PrimeInt.add_carry(L.value[i], kc, x1);
            int x2 = S.value[i] + x1;
            kc += PrimeInt.add_carry(S.value[i], x1, x2);
            c.value[i] = x2;
        }
        while (i < L.wordLength) {
            x1 = L.value[i] + kc;
            kc = PrimeInt.add_carry(L.value[i], kc, x1);
            c.value[i] = x1;
            ++i;
        }
        if (kc != 0) {
            c.value[i] = kc;
            ++c.wordLength;
        }
    }

    public PrimeInt add(PrimeInt other) {
        if (other.wordLength >= this.wordLength) {
            int res_length = other.wordLength;
        } else {
            int res_length = this.wordLength;
        }
        PrimeInt result = new PrimeInt(this.wordLength + 1);
        PrimeInt.add(this, other, result);
        return result;
    }

    public PrimeInt subtract(PrimeInt other) {
        int x;
        int i;
        int kc = 0;
        PrimeInt result = new PrimeInt(this.wordLength);
        result.wordLength = this.wordLength;
        for (i = 0; i < other.wordLength; ++i) {
            x = this.value[i] - kc;
            kc = PrimeInt.sub_carry(this.value[i], kc, x);
            int y = x - other.value[i];
            kc += PrimeInt.sub_carry(x, other.value[i], y);
            result.value[i] = y;
        }
        while (i < this.wordLength) {
            x = this.value[i] - kc;
            kc = PrimeInt.sub_carry(this.value[i], kc, x);
            result.value[i] = x;
            ++i;
        }
        result.trim();
        return result;
    }

    public PrimeInt multiply(PrimeInt other) {
        PrimeInt result = new PrimeInt(this.wordLength + other.wordLength);
        PrimeInt.mult(this, other, result);
        return result;
    }

    public PrimeInt remainder(PrimeInt d) {
        PrimeInt R = new PrimeInt(this);
        PrimeInt.div(R, d, null);
        return R;
    }

    public PrimeInt modPow(PrimeInt e, PrimeInt mod) {
        int max_size = mod.wordLength * 2 + 2;
        PrimeInt N = new PrimeInt(mod);
        N.expand(max_size);
        PrimeInt temp = null;
        byte[] b_one = new byte[]{1};
        PrimeInt A = new PrimeInt(b_one);
        A.expand(max_size);
        PrimeInt S = new PrimeInt(this);
        S.expand(max_size);
        PrimeInt E = new PrimeInt(e);
        PrimeInt aux = new PrimeInt(max_size);
        while (E.wordLength != 0) {
            if ((E.value[0] & 1) == 1) {
                PrimeInt.mult(A, S, aux);
                temp = A;
                A = aux;
                aux = temp;
                PrimeInt.div(A, N, null);
            }
            E.shr(1);
            PrimeInt.mult(S, S, aux);
            temp = S;
            S = aux;
            aux = temp;
            PrimeInt.div(S, N, null);
        }
        return A;
    }

    public int compareTo(PrimeInt other) {
        this.trim();
        other.trim();
        if (this.wordLength > other.wordLength) {
            return 1;
        }
        if (this.wordLength < other.wordLength) {
            return -1;
        }
        for (int i = this.wordLength - 1; i >= 0; --i) {
            long A = (long)this.value[i] & 0xFFFFFFFFL;
            long B = (long)other.value[i] & 0xFFFFFFFFL;
            if (A > B) {
                return 1;
            }
            if (A >= B) continue;
            return -1;
        }
        return 0;
    }

    public int bitLength() {
        this.trim();
        if (this.wordLength == 0) {
            return 0;
        }
        long top = (long)this.value[this.wordLength - 1] & 0xFFFFFFFFL;
        if (top == 0L) {
            return 0;
        }
        int bits = 0;
        while (top != 0L) {
            top >>= 1;
            ++bits;
        }
        return (this.wordLength - 1) * 32 + bits;
    }

    public PrimeInt(int wordsize) {
        this.value = new int[wordsize];
        this.wordLength = 0;
    }

    public PrimeInt(int n, Random _random) {
        this.wordLength = (n + 31) / 32;
        this.value = new int[this.wordLength];
        for (int i = 0; i < this.wordLength; ++i) {
            this.value[i] = _random.nextInt();
        }
    }

    public void shl(int n) {
        int i;
        if (n < 0) {
            this.shr(-n);
        }
        int large = n / 32;
        int small = n & 0x1F;
        this.expand(this.wordLength + large + 1);
        if (large > 0) {
            System.arraycopy(this.value, 0, this.value, large, this.wordLength);
            for (i = 0; i < large; ++i) {
                this.value[i] = 0;
            }
        }
        if (small > 0) {
            this.value[this.wordLength + large] = 0;
            for (i = this.wordLength + large; i > large; --i) {
                this.value[i] = this.value[i] << small | this.value[i - 1] >>> 32 - small;
            }
            this.value[large] = this.value[large] << small;
        }
        this.wordLength += large;
        if (small > 0) {
            ++this.wordLength;
        }
        this.trim();
    }

    public void shr(int n) {
        int i;
        if (n < 0) {
            this.shl(-n);
        }
        if (this.wordLength == 0) {
            return;
        }
        int large = n / 32;
        int small = n & 0x1F;
        if (large >= this.wordLength) {
            for (int i2 = 0; i2 < this.wordLength; ++i2) {
                this.value[i2] = 0;
            }
            return;
        }
        if (large > 0) {
            System.arraycopy(this.value, large, this.value, 0, this.wordLength - large);
            for (i = this.wordLength - large; i < this.wordLength; ++i) {
                this.value[i] = 0;
            }
        }
        if (small > 0) {
            for (i = 0; i < this.wordLength - large - 1; ++i) {
                this.value[i] = this.value[i] >>> small | this.value[i + 1] << 32 - small;
            }
            this.value[this.wordLength - large - 1] = this.value[this.wordLength - large - 1] >>> small;
        }
        this.trim();
    }

    private static int divqhat(int rh, int rl, int d) {
        if (((long)d & 0xFFFFFFFFL) <= ((long)rh & 0xFFFFFFFFL)) {
            return -1;
        }
        long qd = 0L;
        for (int i = 0; i < 32; ++i) {
            long c = rh & Integer.MIN_VALUE;
            rh = rh << 1 | rl >>> 31;
            rl <<= 1;
            qd <<= 1;
            if (c == 0L && ((long)rh & 0xFFFFFFFFL) < ((long)d & 0xFFFFFFFFL)) continue;
            ++qd;
            rh -= d;
        }
        return (int)qd;
    }

    private int multiply_and_subtract(int a, PrimeInt b, int index) {
        int i;
        long along = (long)a & 0xFFFFFFFFL;
        long carry = 0L;
        for (i = 0; i < b.wordLength && i + index < this.wordLength; ++i) {
            long prod = ((long)b.value[i] & 0xFFFFFFFFL) * along + carry;
            long diff = ((long)this.value[i + index] & 0xFFFFFFFFL) - prod;
            this.value[i + index] = (int)diff;
            carry = (prod >>> 32) + (long)((diff & 0xFFFFFFFFL) > ((long)(~((int)prod)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        while (i + index < this.wordLength && carry != 0L) {
            long diff = ((long)this.value[i + index] & 0xFFFFFFFFL) - carry;
            this.value[i + index] = (int)diff;
            carry = (carry >>> 32) + (long)((diff & 0xFFFFFFFFL) > ((long)(~((int)carry)) & 0xFFFFFFFFL) ? 1 : 0);
            ++i;
        }
        return (int)carry;
    }

    private int div_addback(PrimeInt a, int index) {
        long sum;
        int i;
        long carry = 0L;
        for (i = 0; i < a.wordLength && i + index < this.wordLength; ++i) {
            sum = ((long)a.value[i] & 0xFFFFFFFFL) + ((long)this.value[i + index] & 0xFFFFFFFFL) + carry;
            this.value[i + index] = (int)sum;
            carry = sum >>> 32;
        }
        while (i + index < this.wordLength && carry != 0L) {
            sum = ((long)this.value[i + index] & 0xFFFFFFFFL) + carry;
            this.value[i + index] = (int)sum;
            carry = sum >>> 32;
            ++i;
        }
        return (int)carry;
    }

    protected static void div(PrimeInt u, PrimeInt v, PrimeInt q) {
        int m;
        int tw = v.value[v.wordLength - 1];
        int norm = 0;
        while ((tw & Integer.MIN_VALUE) == 0) {
            ++norm;
            tw <<= 1;
        }
        if (v.wordLength == 1) {
            norm += 32;
        }
        if (u.wordLength < v.wordLength) {
            if (q != null) {
                q.wordLength = 0;
                q.value[0] = 0;
            }
            return;
        }
        v.shl(norm);
        u.shl(norm);
        u.expand(u.wordLength + 1);
        int n = v.wordLength;
        for (int j = m = u.wordLength - v.wordLength; j >= 0; --j) {
            int qhat = PrimeInt.divqhat(u.value[j + n], u.value[j + n - 1], v.value[n - 1]);
            if (qhat != 0) {
                u.multiply_and_subtract(qhat, v, j);
            }
            while (u.value[j + n] != 0) {
                u.div_addback(v, j);
                --qhat;
            }
            if (q == null || q.value.length <= j) continue;
            q.value[j] = qhat;
        }
        if (q != null) {
            q.wordLength = m + 1;
            q.trim();
        }
        u.shr(norm);
        u.trim();
        v.shr(norm);
        v.trim();
    }

    private static int add_carry(int x, int y, int z) {
        if (x >= 0) {
            if (y < 0 && z >= 0) {
                return 1;
            }
        } else {
            if (y < 0) {
                return 1;
            }
            if (z >= 0) {
                return 1;
            }
        }
        return 0;
    }

    private static int sub_carry(int x, int y, int z) {
        if (x >= 0) {
            if (y < 0) {
                return 1;
            }
            if (z < 0) {
                return 1;
            }
        } else if (y < 0 && z < 0) {
            return 1;
        }
        return 0;
    }

    private void trim() {
        while (this.wordLength > 0 && this.value[this.wordLength - 1] == 0) {
            --this.wordLength;
        }
    }

    protected static void mult(PrimeInt a, PrimeInt other, PrimeInt result) {
        result.wordLength = a.wordLength + other.wordLength;
        for (int i = 0; i < result.wordLength; ++i) {
            result.value[i] = 0;
        }
        if (a.wordLength == 0 && a.value[0] == 0 || other.wordLength == 0 && other.value[0] == 0) {
            result.wordLength = 0;
            result.value[0] = 0;
            return;
        }
        int k = 0;
        for (int i = 0; i < a.wordLength; ++i) {
            long x = 0L;
            for (int j = 0; j < other.wordLength; ++j) {
                x = ((long)a.value[i] & 0xFFFFFFFFL) * ((long)other.value[j] & 0xFFFFFFFFL) + ((long)result.value[k] & 0xFFFFFFFFL) + (x >> 32 & 0xFFFFFFFFL);
                result.value[k++] = (int)x;
            }
            result.value[k] = (int)(x >> 32);
            k = k - other.wordLength + 1;
        }
        result.trim();
    }

    public void expand(int size) {
        if (size <= this.value.length) {
            return;
        }
        int[] newdigs = new int[size];
        System.arraycopy(this.value, 0, newdigs, 0, this.wordLength);
        this.value = newdigs;
    }

    public static PrimeInt valueOf(int i) {
        PrimeInt res = new PrimeInt(1);
        res.value[0] = i;
        res.wordLength = 1;
        return res;
    }

    public PrimeInt mod(PrimeInt bigModP) {
        return this.remainder(bigModP);
    }

    public int intValue() {
        return this.value[0];
    }

    public boolean equals(PrimeInt b) {
        if (this.wordLength < b.wordLength) {
            int i;
            for (i = 0; i < this.wordLength; ++i) {
                if (this.value[i] == b.value[i]) continue;
                return false;
            }
            while (i < b.wordLength) {
                if (b.value[i] != 0) {
                    return false;
                }
                ++i;
            }
        } else {
            int i;
            for (i = 0; i < b.wordLength; ++i) {
                if (this.value[i] == b.value[i]) continue;
                return false;
            }
            while (i < this.wordLength) {
                if (this.value[i] != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected static final void copyvalue(PrimeInt src, PrimeInt dest) {
        System.arraycopy(src.value, 0, dest.value, 0, src.wordLength);
        dest.wordLength = src.wordLength;
    }
}

