/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import com.cryptomathic.crypto.minimal.RSAPrivateKey;
import com.cryptomathic.crypto.minimal.UByteArray;

public final class ISO9796 {
    private static final byte[] _permutation = new byte[]{14, 3, 5, 8, 9, 4, 2, 15, 0, 13, 11, 6, 7, 10, 12, 1};
    private static final byte[] _shadow = new byte[256];
    private static final byte[] _inverse_shadow = new byte[256];

    public static byte[] sign(RSAPrivateKey privateKey, byte[] message) {
        int r = 1;
        int ks = privateKey.getModulusbitLength() - 1;
        if (message.length * 16 > ks + 3) {
            throw new IllegalArgumentException("Message too short.");
        }
        byte[] ir = null;
        byte[][] mr = null;
        ir = ISO9796.putRedundancy(message, ks, r);
        UByteArray.clearBits(ir, ks, ir.length * 8 - ks);
        ir[ir.length - 1] = (byte)(ir[ir.length - 1] << 4 | 6);
        UByteArray.setBit(ir, ks - 1);
        return privateKey.exp(ir);
    }

    public static byte[] putRedundancy(byte[] message, int k_s, int r) {
        Integer minimum_bits = new Integer(k_s - 1);
        int t = new Double(Math.ceil(minimum_bits.doubleValue() / 16.0)).intValue();
        int t2 = 2 * t;
        int z = message.length;
        byte[] mr = new byte[2 * t];
        byte[] ir = null;
        for (int i = 0; i < t; ++i) {
            int j = z - 1 - i % z;
            mr[t2 - 1 - 2 * i] = message[j];
            int index = message[j] < 0 ? 256 + message[j] : message[j];
            mr[t2 - 1 - (2 * i + 1)] = _shadow[index];
        }
        int n = t2 - 1 - (2 * z - 1);
        mr[n] = (byte)(mr[n] ^ (byte)r);
        if ((k_s - 1) % 8 == 0) {
            ir = new byte[t2 + 1];
            System.arraycopy(mr, 0, ir, 1, mr.length);
            mr = ir;
        }
        return mr;
    }

    static {
        for (int i = 0; i < _permutation.length; ++i) {
            byte P_mu2 = (byte)(_permutation[i] << 4);
            for (int j = 0; j < _permutation.length; ++j) {
                ISO9796._shadow[i * 16 + j] = (byte)(P_mu2 | _permutation[j]);
            }
        }
        int index = 0;
        for (int i = 0; i < _inverse_shadow.length; ++i) {
            index = _shadow[i] < 0 ? 256 + _shadow[i] : _shadow[i];
            ISO9796._inverse_shadow[index] = (byte)i;
        }
    }
}

