/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import com.cryptomathic.crypto.minimal.Convert;
import com.cryptomathic.crypto.minimal.Pc2b;
import com.cryptomathic.crypto.minimal.Sboxp;

public final class DesKernel {
    static int[] Shift = new int[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
    static int[] Shift_28 = new int[]{27, 27, 26, 26, 26, 26, 26, 26, 27, 26, 26, 26, 26, 26, 26, 27};

    public static int[] des_make_keys(byte[] k) {
        int[] K = new int[32];
        int c = Convert.lendian_byte2int(k, 0);
        int d = Convert.lendian_byte2int(k, 4);
        int t = (d >>> 4 ^ c) & 0xF0F0F0F;
        c ^= t;
        d ^= t << 4;
        t = (c << 18 ^ c) & 0xCCCC0000;
        c ^= t ^ t >>> 18;
        t = (d << 18 ^ d) & 0xCCCC0000;
        d ^= t ^ t >>> 18;
        t = (d >>> 1 ^ c) & 0x55555555;
        c ^= t;
        d ^= t << 1;
        t = (c >>> 8 ^ d) & 0xFF00FF;
        d ^= t;
        c ^= t << 8;
        t = (d >>> 1 ^ c) & 0x55555555;
        d ^= t << 1;
        d = (d & 0xFF) << 16 | d & 0xFF00 | (d & 0xFF0000) >>> 16 | ((c ^= t) & 0xF0000000) >>> 4;
        c &= 0xFFFFFFF;
        for (int i = 0; i < 16; ++i) {
            c = c >>> Shift[i] | c << Shift_28[i];
            d = d >>> Shift[i] | d << Shift_28[i];
            int k0 = Pc2b.PC2b[0][c & 0xFF][0];
            int k1 = Pc2b.PC2b[0][c & 0xFF][1];
            k0 |= Pc2b.PC2b[4][d & 0xFF][0];
            k1 |= Pc2b.PC2b[4][d & 0xFF][1];
            k0 |= Pc2b.PC2b[1][c >>> 8 & 0xFF][0];
            k1 |= Pc2b.PC2b[1][c >>> 8 & 0xFF][1];
            k0 |= Pc2b.PC2b[5][d >>> 8 & 0xFF][0];
            k1 |= Pc2b.PC2b[5][d >>> 8 & 0xFF][1];
            k0 |= Pc2b.PC2b[2][c >>> 16 & 0xFF][0];
            k1 |= Pc2b.PC2b[2][c >>> 16 & 0xFF][1];
            k0 |= Pc2b.PC2b[6][d >>> 16 & 0xFF][0];
            k1 |= Pc2b.PC2b[6][d >>> 16 & 0xFF][1];
            k0 |= Pc2b.PC2b[3][c >>> 24][0];
            k1 |= Pc2b.PC2b[3][c >>> 24][1];
            K[2 * i] = k0 |= Pc2b.PC2b[7][d >>> 24][0];
            K[2 * i + 1] = k1 |= Pc2b.PC2b[7][d >>> 24][1];
        }
        return K;
    }

    public static void des_encrypt(int[] K, byte[] m, int offs, byte[] output, int outputoffs) {
        DesKernel.des_encrypt(K, m, offs, output, outputoffs, true, true);
    }

    private static void des_encrypt(int[] K, byte[] m, int offs, byte[] output, int outputoffs, boolean IP_1, boolean IP_2) {
        long input;
        int kpt = 0;
        int edx = Convert.lendian_byte2int(m, offs);
        int edi = Convert.lendian_byte2int(m, offs + 4);
        if (IP_1) {
            input = (long)edx << 32 | (long)edi & 0xFFFFFFFFL;
            input = DesKernel.IP_1(input);
            edx = (int)(input >>> 32);
            edi = (int)(input & 0xFFFFFFFFL);
        }
        for (int i = 0; i < 8; ++i) {
            int eax = (edx >>> 16 | edx << 16) ^ K[kpt];
            int tmp = (edx << 20 | edx >>> 12) ^ K[++kpt];
            edi ^= Sboxp.SBOX[5][eax >>> 2 & 0x3F] ^ Sboxp.SBOX[7][eax >>> 10 & 0x3F] ^ Sboxp.SBOX[1][eax >>> 18 & 0x3F] ^ Sboxp.SBOX[3][eax >>> 26] ^ Sboxp.SBOX[4][tmp >>> 2 & 0x3F] ^ Sboxp.SBOX[6][tmp >>> 10 & 0x3F] ^ Sboxp.SBOX[0][tmp >>> 18 & 0x3F] ^ Sboxp.SBOX[2][tmp >>> 26];
            eax = (edi >>> 16 | edi << 16) ^ K[++kpt];
            tmp = (edi << 20 | edi >>> 12) ^ K[++kpt];
            ++kpt;
            edx ^= Sboxp.SBOX[5][eax >>> 2 & 0x3F] ^ Sboxp.SBOX[7][eax >>> 10 & 0x3F] ^ Sboxp.SBOX[1][eax >>> 18 & 0x3F] ^ Sboxp.SBOX[3][eax >>> 26] ^ Sboxp.SBOX[4][tmp >>> 2 & 0x3F] ^ Sboxp.SBOX[6][tmp >>> 10 & 0x3F] ^ Sboxp.SBOX[0][tmp >>> 18 & 0x3F] ^ Sboxp.SBOX[2][tmp >>> 26];
        }
        if (IP_2) {
            input = (long)edx << 32 | (long)edi & 0xFFFFFFFFL;
            input = DesKernel.IP_2(input);
            edx = (int)(input >>> 32);
            edi = (int)(input & 0xFFFFFFFFL);
        }
        Convert.lendian_int2byte(output, outputoffs, edi);
        Convert.lendian_int2byte(output, outputoffs + 4, edx);
    }

    public static void des_decrypt(int[] K, byte[] m, int offs, byte[] output, int outputoffs) {
        DesKernel.des_decrypt(K, m, offs, output, outputoffs, true, true);
    }

    private static void des_decrypt(int[] K, byte[] c, int offs, byte[] output, int outputoffs, boolean IP_1, boolean IP_2) {
        long input;
        int kpt = 32;
        int edx = Convert.lendian_byte2int(c, offs);
        int edi = Convert.lendian_byte2int(c, offs + 4);
        if (IP_1) {
            input = (long)edx << 32 | (long)edi & 0xFFFFFFFFL;
            input = DesKernel.IP_1(input);
            edx = (int)(input >>> 32);
            edi = (int)(input & 0xFFFFFFFFL);
        }
        for (int i = 0; i < 8; ++i) {
            int eax = (edx << 20 | edx >>> 12) ^ K[--kpt];
            int tmp = (edx >>> 16 | edx << 16) ^ K[--kpt];
            edi ^= Sboxp.SBOX[4][eax >>> 2 & 0x3F] ^ Sboxp.SBOX[6][eax >>> 10 & 0x3F] ^ Sboxp.SBOX[0][eax >>> 18 & 0x3F] ^ Sboxp.SBOX[2][eax >>> 26] ^ Sboxp.SBOX[5][tmp >>> 2 & 0x3F] ^ Sboxp.SBOX[7][tmp >>> 10 & 0x3F] ^ Sboxp.SBOX[1][tmp >>> 18 & 0x3F] ^ Sboxp.SBOX[3][tmp >>> 26];
            eax = (edi << 20 | edi >>> 12) ^ K[--kpt];
            tmp = (edi >>> 16 | edi << 16) ^ K[--kpt];
            edx ^= Sboxp.SBOX[4][eax >>> 2 & 0x3F] ^ Sboxp.SBOX[6][eax >>> 10 & 0x3F] ^ Sboxp.SBOX[0][eax >>> 18 & 0x3F] ^ Sboxp.SBOX[2][eax >>> 26] ^ Sboxp.SBOX[5][tmp >>> 2 & 0x3F] ^ Sboxp.SBOX[7][tmp >>> 10 & 0x3F] ^ Sboxp.SBOX[1][tmp >>> 18 & 0x3F] ^ Sboxp.SBOX[3][tmp >>> 26];
        }
        if (IP_2) {
            input = (long)edx << 32 | (long)edi & 0xFFFFFFFFL;
            input = DesKernel.IP_2(input);
            edx = (int)(input >>> 32);
            edi = (int)(input & 0xFFFFFFFFL);
        }
        Convert.lendian_int2byte(output, outputoffs, edi);
        Convert.lendian_int2byte(output, outputoffs + 4, edx);
    }

    public static void des3_decrypt(int[] K1, int[] K2, byte[] c, int offs, byte[] output, int outputoffs) {
        DesKernel.des_decrypt(K1, c, offs, output, outputoffs, true, false);
        DesKernel.des_encrypt(K2, output, outputoffs, output, outputoffs, false, false);
        DesKernel.des_decrypt(K1, output, outputoffs, output, outputoffs, false, true);
    }

    public static void des3_encrypt(int[] K1, int[] K2, byte[] c, int offs, byte[] output, int outputoffs) {
        DesKernel.des_encrypt(K1, c, offs, output, outputoffs, true, false);
        DesKernel.des_decrypt(K2, output, outputoffs, output, outputoffs, false, false);
        DesKernel.des_encrypt(K1, output, outputoffs, output, outputoffs, false, true);
    }

    private static long IP_1(long input) {
        int edi = (int)(input & 0xFFFFFFFFL);
        int edx = (int)(input >>> 32);
        int tmp = (edi >>> 4 ^ edx) & 0xF0F0F0F;
        edx ^= tmp;
        edi ^= tmp << 4;
        tmp = (edx >>> 16 ^ edi) & 0xFFFF;
        edi ^= tmp;
        edx ^= tmp << 16;
        tmp = (edi >>> 2 ^ edx) & 0x33333333;
        edx ^= tmp;
        edi ^= tmp << 2;
        tmp = (edx >>> 8 ^ edi) & 0xFF00FF;
        edi ^= tmp;
        edx ^= tmp << 8;
        tmp = (edi >>> 1 ^ edx) & 0x55555555;
        edx ^= tmp;
        edi ^= tmp << 1;
        edi = edi >>> 1 | edi << 31;
        edx = edx >>> 1 | edx << 31;
        return (long)edx << 32 | (long)edi & 0xFFFFFFFFL;
    }

    private static long IP_2(long input) {
        int edi = (int)(input & 0xFFFFFFFFL);
        int edx = (int)(input >>> 32);
        edi = edi << 1 | edi >>> 31;
        edx = edx << 1 | edx >>> 31;
        int tmp = (edx >>> 1 ^ edi) & 0x55555555;
        edi ^= tmp;
        edx ^= tmp << 1;
        tmp = (edi >>> 8 ^ edx) & 0xFF00FF;
        edx ^= tmp;
        edi ^= tmp << 8;
        tmp = (edx >>> 2 ^ edi) & 0x33333333;
        edi ^= tmp;
        edx ^= tmp << 2;
        tmp = (edi >>> 16 ^ edx) & 0xFFFF;
        edx ^= tmp;
        edi ^= tmp << 16;
        tmp = (edx >>> 4 ^ edi) & 0xF0F0F0F;
        return (long)(edx ^= tmp << 4) << 32 | (long)(edi ^= tmp) & 0xFFFFFFFFL;
    }
}

