/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

class StateRIPEMD
extends HashState {
    private static int h1 = 1732584193;
    private static int h2 = -271733879;
    private static int h3 = -1732584194;
    private static int h4 = 271733878;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    protected StateRIPEMD() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[16];
        Convert.lendian_int2byte(this.state, 0, h1);
        Convert.lendian_int2byte(this.state, 4, h2);
        Convert.lendian_int2byte(this.state, 8, h3);
        Convert.lendian_int2byte(this.state, 12, h4);
        this.hash_size = 16;
        this.hashtype = HashType.RIPEMD;
    }

    protected void hash(byte[] mes, int offset) {
        int[] w = new int[16];
        this.H1 = Convert.lendian_byte2int(this.state, 0);
        this.H2 = Convert.lendian_byte2int(this.state, 4);
        this.H3 = Convert.lendian_byte2int(this.state, 8);
        this.H4 = Convert.lendian_byte2int(this.state, 12);
        for (int i = 0; i < 16; ++i) {
            w[i] = Convert.lendian_byte2int(mes, 4 * i + offset);
        }
        int eax = this.H1;
        int ebx = this.H2;
        int ecx = this.H3;
        int edx = this.H4;
        eax += (ebx & ecx | ~ebx & edx) + w[0];
        eax = eax << 11 | eax >>> 21;
        edx += (eax & ebx | ~eax & ecx) + w[1];
        edx = edx << 14 | edx >>> 18;
        ecx += (edx & eax | ~edx & ebx) + w[2];
        ecx = ecx << 15 | ecx >>> 17;
        ebx += (ecx & edx | ~ecx & eax) + w[3];
        ebx = ebx << 12 | ebx >>> 20;
        eax += (ebx & ecx | ~ebx & edx) + w[4];
        eax = eax << 5 | eax >>> 27;
        edx += (eax & ebx | ~eax & ecx) + w[5];
        edx = edx << 8 | edx >>> 24;
        ecx += (edx & eax | ~edx & ebx) + w[6];
        ecx = ecx << 7 | ecx >>> 25;
        ebx += (ecx & edx | ~ecx & eax) + w[7];
        ebx = ebx << 9 | ebx >>> 23;
        eax += (ebx & ecx | ~ebx & edx) + w[8];
        eax = eax << 11 | eax >>> 21;
        edx += (eax & ebx | ~eax & ecx) + w[9];
        edx = edx << 13 | edx >>> 19;
        ecx += (edx & eax | ~edx & ebx) + w[10];
        ecx = ecx << 14 | ecx >>> 18;
        ebx += (ecx & edx | ~ecx & eax) + w[11];
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx & ecx | ~ebx & edx) + w[12];
        eax = eax << 6 | eax >>> 26;
        edx += (eax & ebx | ~eax & ecx) + w[13];
        edx = edx << 7 | edx >>> 25;
        ecx += (edx & eax | ~edx & ebx) + w[14];
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx & edx | ~ecx & eax) + w[15];
        ebx = ebx << 8 | ebx >>> 24;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[7] + 1518500249;
        eax = eax << 7 | eax >>> 25;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[4] + 1518500249;
        edx = edx << 6 | edx >>> 26;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[13] + 1518500249;
        ecx = ecx << 8 | ecx >>> 24;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[1] + 1518500249;
        ebx = ebx << 13 | ebx >>> 19;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[10] + 1518500249;
        eax = eax << 11 | eax >>> 21;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[6] + 1518500249;
        edx = edx << 9 | edx >>> 23;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[15] + 1518500249;
        ecx = ecx << 7 | ecx >>> 25;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[3] + 1518500249;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[12] + 1518500249;
        eax = eax << 7 | eax >>> 25;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[0] + 1518500249;
        edx = edx << 12 | edx >>> 20;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[9] + 1518500249;
        ecx = ecx << 15 | ecx >>> 17;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[5] + 1518500249;
        ebx = ebx << 9 | ebx >>> 23;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[14] + 1518500249;
        eax = eax << 7 | eax >>> 25;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[2] + 1518500249;
        edx = edx << 11 | edx >>> 21;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[11] + 1518500249;
        ecx = ecx << 13 | ecx >>> 19;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[8] + 1518500249;
        ebx = ebx << 12 | ebx >>> 20;
        eax += (ebx ^ ecx ^ edx) + w[3] + 1859775393;
        eax = eax << 11 | eax >>> 21;
        edx += (eax ^ ebx ^ ecx) + w[10] + 1859775393;
        edx = edx << 13 | edx >>> 19;
        ecx += (edx ^ eax ^ ebx) + w[2] + 1859775393;
        ecx = ecx << 14 | ecx >>> 18;
        ebx += (ecx ^ edx ^ eax) + w[4] + 1859775393;
        ebx = ebx << 7 | ebx >>> 25;
        eax += (ebx ^ ecx ^ edx) + w[9] + 1859775393;
        eax = eax << 14 | eax >>> 18;
        edx += (eax ^ ebx ^ ecx) + w[15] + 1859775393;
        edx = edx << 9 | edx >>> 23;
        ecx += (edx ^ eax ^ ebx) + w[8] + 1859775393;
        ecx = ecx << 13 | ecx >>> 19;
        ebx += (ecx ^ edx ^ eax) + w[1] + 1859775393;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx ^ ecx ^ edx) + w[14] + 1859775393;
        eax = eax << 6 | eax >>> 26;
        edx += (eax ^ ebx ^ ecx) + w[7] + 1859775393;
        edx = edx << 8 | edx >>> 24;
        ecx += (edx ^ eax ^ ebx) + w[0] + 1859775393;
        ecx = ecx << 13 | ecx >>> 19;
        ebx += (ecx ^ edx ^ eax) + w[6] + 1859775393;
        ebx = ebx << 6 | ebx >>> 26;
        eax += (ebx ^ ecx ^ edx) + w[11] + 1859775393;
        eax = eax << 12 | eax >>> 20;
        edx += (eax ^ ebx ^ ecx) + w[13] + 1859775393;
        edx = edx << 5 | edx >>> 27;
        ecx += (edx ^ eax ^ ebx) + w[5] + 1859775393;
        ecx = ecx << 7 | ecx >>> 25;
        ebx += (ecx ^ edx ^ eax) + w[12] + 1859775393;
        ebx = ebx << 5 | ebx >>> 27;
        int EAX = this.H1;
        int EBX = this.H2;
        int ECX = this.H3;
        int EDX = this.H4;
        EAX += (EBX & ECX | ~EBX & EDX) + w[0] + 1352829926;
        EAX = EAX << 11 | EAX >>> 21;
        EDX += (EAX & EBX | ~EAX & ECX) + w[1] + 1352829926;
        EDX = EDX << 14 | EDX >>> 18;
        ECX += (EDX & EAX | ~EDX & EBX) + w[2] + 1352829926;
        ECX = ECX << 15 | ECX >>> 17;
        EBX += (ECX & EDX | ~ECX & EAX) + w[3] + 1352829926;
        EBX = EBX << 12 | EBX >>> 20;
        EAX += (EBX & ECX | ~EBX & EDX) + w[4] + 1352829926;
        EAX = EAX << 5 | EAX >>> 27;
        EDX += (EAX & EBX | ~EAX & ECX) + w[5] + 1352829926;
        EDX = EDX << 8 | EDX >>> 24;
        ECX += (EDX & EAX | ~EDX & EBX) + w[6] + 1352829926;
        ECX = ECX << 7 | ECX >>> 25;
        EBX += (ECX & EDX | ~ECX & EAX) + w[7] + 1352829926;
        EBX = EBX << 9 | EBX >>> 23;
        EAX += (EBX & ECX | ~EBX & EDX) + w[8] + 1352829926;
        EAX = EAX << 11 | EAX >>> 21;
        EDX += (EAX & EBX | ~EAX & ECX) + w[9] + 1352829926;
        EDX = EDX << 13 | EDX >>> 19;
        ECX += (EDX & EAX | ~EDX & EBX) + w[10] + 1352829926;
        ECX = ECX << 14 | ECX >>> 18;
        EBX += (ECX & EDX | ~ECX & EAX) + w[11] + 1352829926;
        EBX = EBX << 15 | EBX >>> 17;
        EAX += (EBX & ECX | ~EBX & EDX) + w[12] + 1352829926;
        EAX = EAX << 6 | EAX >>> 26;
        EDX += (EAX & EBX | ~EAX & ECX) + w[13] + 1352829926;
        EDX = EDX << 7 | EDX >>> 25;
        ECX += (EDX & EAX | ~EDX & EBX) + w[14] + 1352829926;
        ECX = ECX << 9 | ECX >>> 23;
        EBX += (ECX & EDX | ~ECX & EAX) + w[15] + 1352829926;
        EBX = EBX << 8 | EBX >>> 24;
        EAX += (EBX & ECX | EBX & EDX | ECX & EDX) + w[7];
        EAX = EAX << 7 | EAX >>> 25;
        EDX += (EAX & EBX | EAX & ECX | EBX & ECX) + w[4];
        EDX = EDX << 6 | EDX >>> 26;
        ECX += (EDX & EAX | EDX & EBX | EAX & EBX) + w[13];
        ECX = ECX << 8 | ECX >>> 24;
        EBX += (ECX & EDX | ECX & EAX | EDX & EAX) + w[1];
        EBX = EBX << 13 | EBX >>> 19;
        EAX += (EBX & ECX | EBX & EDX | ECX & EDX) + w[10];
        EAX = EAX << 11 | EAX >>> 21;
        EDX += (EAX & EBX | EAX & ECX | EBX & ECX) + w[6];
        EDX = EDX << 9 | EDX >>> 23;
        ECX += (EDX & EAX | EDX & EBX | EAX & EBX) + w[15];
        ECX = ECX << 7 | ECX >>> 25;
        EBX += (ECX & EDX | ECX & EAX | EDX & EAX) + w[3];
        EBX = EBX << 15 | EBX >>> 17;
        EAX += (EBX & ECX | EBX & EDX | ECX & EDX) + w[12];
        EAX = EAX << 7 | EAX >>> 25;
        EDX += (EAX & EBX | EAX & ECX | EBX & ECX) + w[0];
        EDX = EDX << 12 | EDX >>> 20;
        ECX += (EDX & EAX | EDX & EBX | EAX & EBX) + w[9];
        ECX = ECX << 15 | ECX >>> 17;
        EBX += (ECX & EDX | ECX & EAX | EDX & EAX) + w[5];
        EBX = EBX << 9 | EBX >>> 23;
        EAX += (EBX & ECX | EBX & EDX | ECX & EDX) + w[14];
        EAX = EAX << 7 | EAX >>> 25;
        EDX += (EAX & EBX | EAX & ECX | EBX & ECX) + w[2];
        EDX = EDX << 11 | EDX >>> 21;
        ECX += (EDX & EAX | EDX & EBX | EAX & EBX) + w[11];
        ECX = ECX << 13 | ECX >>> 19;
        EBX += (ECX & EDX | ECX & EAX | EDX & EAX) + w[8];
        EBX = EBX << 12 | EBX >>> 20;
        EAX += (EBX ^ ECX ^ EDX) + w[3] + 1548603684;
        EAX = EAX << 11 | EAX >>> 21;
        EDX += (EAX ^ EBX ^ ECX) + w[10] + 1548603684;
        EDX = EDX << 13 | EDX >>> 19;
        ECX += (EDX ^ EAX ^ EBX) + w[2] + 1548603684;
        ECX = ECX << 14 | ECX >>> 18;
        EBX += (ECX ^ EDX ^ EAX) + w[4] + 1548603684;
        EBX = EBX << 7 | EBX >>> 25;
        EAX += (EBX ^ ECX ^ EDX) + w[9] + 1548603684;
        EAX = EAX << 14 | EAX >>> 18;
        EDX += (EAX ^ EBX ^ ECX) + w[15] + 1548603684;
        EDX = EDX << 9 | EDX >>> 23;
        ECX += (EDX ^ EAX ^ EBX) + w[8] + 1548603684;
        ECX = ECX << 13 | ECX >>> 19;
        EBX += (ECX ^ EDX ^ EAX) + w[1] + 1548603684;
        EBX = EBX << 15 | EBX >>> 17;
        EAX += (EBX ^ ECX ^ EDX) + w[14] + 1548603684;
        EAX = EAX << 6 | EAX >>> 26;
        EDX += (EAX ^ EBX ^ ECX) + w[7] + 1548603684;
        EDX = EDX << 8 | EDX >>> 24;
        ECX += (EDX ^ EAX ^ EBX) + w[0] + 1548603684;
        ECX = ECX << 13 | ECX >>> 19;
        EBX += (ECX ^ EDX ^ EAX) + w[6] + 1548603684;
        EBX = EBX << 6 | EBX >>> 26;
        EAX += (EBX ^ ECX ^ EDX) + w[11] + 1548603684;
        EAX = EAX << 12 | EAX >>> 20;
        EDX += (EAX ^ EBX ^ ECX) + w[13] + 1548603684;
        EDX = EDX << 5 | EDX >>> 27;
        ECX += (EDX ^ EAX ^ EBX) + w[5] + 1548603684;
        ECX = ECX << 7 | ECX >>> 25;
        EBX += (ECX ^ EDX ^ EAX) + w[12] + 1548603684;
        EBX = EBX << 5 | EBX >>> 27;
        Convert.lendian_int2byte(this.state, 0, (EDX += ecx) + this.H2);
        Convert.lendian_int2byte(this.state, 4, (EAX += edx) + this.H3);
        Convert.lendian_int2byte(this.state, 8, (EBX += eax) + this.H4);
        Convert.lendian_int2byte(this.state, 12, (ECX += ebx) + this.H1);
    }

    protected int pad(HashPadMode pmode) {
        HashPad.RIPEMDPad(this);
        return 1;
    }
}

