/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;

class StateMDC2
extends HashState {
    protected StateMDC2() {
        this.block_size = 8;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[16];
        for (int i = 0; i < 8; ++i) {
            this.state[i] = 82;
            this.state[i + 8] = 37;
        }
        this.hash_size = 16;
        this.hashtype = HashType.MDC2;
    }

    protected void hash(byte[] mes, int offset) {
        int j;
        byte[] H0 = new byte[8];
        byte[] H1 = new byte[8];
        System.arraycopy(this.state, 0, H0, 0, 8);
        System.arraycopy(this.state, 8, H1, 0, 8);
        H0[0] = (byte)(H0[0] & 0xFFFFFF9F | 0x40);
        H1[0] = (byte)(H1[0] & 0xFFFFFF9F | 0x20);
        int[] keys = DesKernel.des_make_keys(H0);
        H0 = DesKernel.des_encrypt(keys, mes, offset);
        for (j = 0; j < 8; ++j) {
            int n = j;
            H0[n] = (byte)(H0[n] ^ mes[j + offset]);
        }
        keys = DesKernel.des_make_keys(H1);
        H1 = DesKernel.des_encrypt(keys, mes, offset);
        for (j = 0; j < 8; ++j) {
            int n = j;
            H1[n] = (byte)(H1[n] ^ mes[j + offset]);
        }
        for (j = 4; j < 8; ++j) {
            int n = j;
            H0[n] = (byte)(H0[n] ^ H1[j]);
            int n2 = j;
            H1[n2] = (byte)(H1[n2] ^ H0[j]);
            int n3 = j;
            H0[n3] = (byte)(H0[n3] ^ H1[j]);
        }
        System.arraycopy(H0, 0, this.state, 0, 8);
        System.arraycopy(H1, 0, this.state, 8, 8);
    }

    protected int pad(HashPadMode pmode) throws HashException {
        int res = 0;
        if (pmode.toInt() != HashPadMode.NOPAD.toInt()) {
            int ref = pmode.toInt();
            if (ref == HashPadMode.MDC.toInt()) {
                HashPad.MDCPad(this);
            } else if (ref == HashPadMode.MDCFF16.toInt()) {
                HashPad.MDCPadFF16(this);
            } else if (ref == HashPadMode.MDCmethod1.toInt()) {
                HashPad.MDCPadMethod1(this);
            } else if (ref == HashPadMode.MDCmethod2.toInt()) {
                HashPad.MDCPadMethod2(this);
            } else {
                throw new HashException("MDC");
            }
            res = 1;
        }
        return res;
    }
}

