/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;

class StateMDC1
extends HashState {
    protected StateMDC1() {
        this.block_size = 8;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[8];
        for (int i = 0; i < 8; ++i) {
            this.state[i] = 82;
        }
        this.hash_size = 8;
        this.hashtype = HashType.MDC1;
    }

    protected void hash(byte[] mes, int offset) {
        this.state[0] = (byte)(this.state[0] & 0xFFFFFF9F | 0x40);
        int[] key = DesKernel.des_make_keys(this.state);
        System.arraycopy(DesKernel.des_encrypt(key, mes, offset), 0, this.state, 0, 8);
        for (int j = 0; j < 8; ++j) {
            int n = j;
            this.state[n] = (byte)(this.state[n] ^ mes[j + offset]);
        }
    }

    protected int pad(HashPadMode pmode) throws HashException {
        int res = 0;
        if (pmode.toInt() != HashPadMode.NOPAD.toInt()) {
            int ref = pmode.toInt();
            if (ref == HashPadMode.MDC.toInt()) {
                HashPad.MDCPad(this);
            } else if (ref == HashPadMode.MDCFF16.toInt()) {
                HashPad.MDCPadFF16(this);
            } else {
                throw new HashException("MDC");
            }
            res = 1;
        }
        return res;
    }
}

