/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

class StateMD5
extends HashState {
    private static int h1 = 1732584193;
    private static int h2 = -271733879;
    private static int h3 = -1732584194;
    private static int h4 = 271733878;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    protected StateMD5() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[16];
        Convert.lendian_int2byte(this.state, 0, h1);
        Convert.lendian_int2byte(this.state, 4, h2);
        Convert.lendian_int2byte(this.state, 8, h3);
        Convert.lendian_int2byte(this.state, 12, h4);
        this.hash_size = 16;
        this.hashtype = HashType.MD5;
    }

    protected void hash(byte[] mes, int offset) {
        int[] w = new int[16];
        this.H1 = Convert.lendian_byte2int(this.state, 0);
        this.H2 = Convert.lendian_byte2int(this.state, 4);
        this.H3 = Convert.lendian_byte2int(this.state, 8);
        this.H4 = Convert.lendian_byte2int(this.state, 12);
        for (int i = 0; i < 16; ++i) {
            w[i] = Convert.lendian_byte2int(mes, 4 * i + offset);
        }
        int eax = this.H1;
        int ebx = this.H2;
        int ecx = this.H3;
        int edx = this.H4;
        eax += (ebx & ecx | ~ebx & edx) + w[0] + -680876936;
        eax = (eax << 7 | eax >>> 25) + ebx;
        edx += (eax & ebx | ~eax & ecx) + w[1] + -389564586;
        edx = (edx << 12 | edx >>> 20) + eax;
        ecx += (edx & eax | ~edx & ebx) + w[2] + 606105819;
        ecx = (ecx << 17 | ecx >>> 15) + edx;
        ebx += (ecx & edx | ~ecx & eax) + w[3] + -1044525330;
        ebx = (ebx << 22 | ebx >>> 10) + ecx;
        eax += (ebx & ecx | ~ebx & edx) + w[4] + -176418897;
        eax = (eax << 7 | eax >>> 25) + ebx;
        edx += (eax & ebx | ~eax & ecx) + w[5] + 1200080426;
        edx = (edx << 12 | edx >>> 20) + eax;
        ecx += (edx & eax | ~edx & ebx) + w[6] + -1473231341;
        ecx = (ecx << 17 | ecx >>> 15) + edx;
        ebx += (ecx & edx | ~ecx & eax) + w[7] + -45705983;
        ebx = (ebx << 22 | ebx >>> 10) + ecx;
        eax += (ebx & ecx | ~ebx & edx) + w[8] + 1770035416;
        eax = (eax << 7 | eax >>> 25) + ebx;
        edx += (eax & ebx | ~eax & ecx) + w[9] + -1958414417;
        edx = (edx << 12 | edx >>> 20) + eax;
        ecx += (edx & eax | ~edx & ebx) + w[10] + -42063;
        ecx = (ecx << 17 | ecx >>> 15) + edx;
        ebx += (ecx & edx | ~ecx & eax) + w[11] + -1990404162;
        ebx = (ebx << 22 | ebx >>> 10) + ecx;
        eax += (ebx & ecx | ~ebx & edx) + w[12] + 1804603682;
        eax = (eax << 7 | eax >>> 25) + ebx;
        edx += (eax & ebx | ~eax & ecx) + w[13] + -40341101;
        edx = (edx << 12 | edx >>> 20) + eax;
        ecx += (edx & eax | ~edx & ebx) + w[14] + -1502002290;
        ecx = (ecx << 17 | ecx >>> 15) + edx;
        ebx += (ecx & edx | ~ecx & eax) + w[15] + 1236535329;
        ebx = (ebx << 22 | ebx >>> 10) + ecx;
        eax += (ebx & edx | ecx & ~edx) + w[1] + -165796510;
        eax = (eax << 5 | eax >>> 27) + ebx;
        edx += (eax & ecx | ebx & ~ecx) + w[6] + -1069501632;
        edx = (edx << 9 | edx >>> 23) + eax;
        ecx += (edx & ebx | eax & ~ebx) + w[11] + 643717713;
        ecx = (ecx << 14 | ecx >>> 18) + edx;
        ebx += (ecx & eax | edx & ~eax) + w[0] + -373897302;
        ebx = (ebx << 20 | ebx >>> 12) + ecx;
        eax += (ebx & edx | ecx & ~edx) + w[5] + -701558691;
        eax = (eax << 5 | eax >>> 27) + ebx;
        edx += (eax & ecx | ebx & ~ecx) + w[10] + 38016083;
        edx = (edx << 9 | edx >>> 23) + eax;
        ecx += (edx & ebx | eax & ~ebx) + w[15] + -660478335;
        ecx = (ecx << 14 | ecx >>> 18) + edx;
        ebx += (ecx & eax | edx & ~eax) + w[4] + -405537848;
        ebx = (ebx << 20 | ebx >>> 12) + ecx;
        eax += (ebx & edx | ecx & ~edx) + w[9] + 568446438;
        eax = (eax << 5 | eax >>> 27) + ebx;
        edx += (eax & ecx | ebx & ~ecx) + w[14] + -1019803690;
        edx = (edx << 9 | edx >>> 23) + eax;
        ecx += (edx & ebx | eax & ~ebx) + w[3] + -187363961;
        ecx = (ecx << 14 | ecx >>> 18) + edx;
        ebx += (ecx & eax | edx & ~eax) + w[8] + 1163531501;
        ebx = (ebx << 20 | ebx >>> 12) + ecx;
        eax += (ebx & edx | ecx & ~edx) + w[13] + -1444681467;
        eax = (eax << 5 | eax >>> 27) + ebx;
        edx += (eax & ecx | ebx & ~ecx) + w[2] + -51403784;
        edx = (edx << 9 | edx >>> 23) + eax;
        ecx += (edx & ebx | eax & ~ebx) + w[7] + 1735328473;
        ecx = (ecx << 14 | ecx >>> 18) + edx;
        ebx += (ecx & eax | edx & ~eax) + w[12] + -1926607734;
        ebx = (ebx << 20 | ebx >>> 12) + ecx;
        eax += (ebx ^ ecx ^ edx) + w[5] + -378558;
        eax = (eax << 4 | eax >>> 28) + ebx;
        edx += (eax ^ ebx ^ ecx) + w[8] + -2022574463;
        edx = (edx << 11 | edx >>> 21) + eax;
        ecx += (eax ^ ebx ^ edx) + w[11] + 1839030562;
        ecx = (ecx << 16 | ecx >>> 16) + edx;
        ebx += (eax ^ ecx ^ edx) + w[14] + -35309556;
        ebx = (ebx << 23 | ebx >>> 9) + ecx;
        eax += (ebx ^ ecx ^ edx) + w[1] + -1530992060;
        eax = (eax << 4 | eax >>> 28) + ebx;
        edx += (eax ^ ebx ^ ecx) + w[4] + 1272893353;
        edx = (edx << 11 | edx >>> 21) + eax;
        ecx += (eax ^ ebx ^ edx) + w[7] + -155497632;
        ecx = (ecx << 16 | ecx >>> 16) + edx;
        ebx += (eax ^ ecx ^ edx) + w[10] + -1094730640;
        ebx = (ebx << 23 | ebx >>> 9) + ecx;
        eax += (ebx ^ ecx ^ edx) + w[13] + 681279174;
        eax = (eax << 4 | eax >>> 28) + ebx;
        edx += (eax ^ ebx ^ ecx) + w[0] + -358537222;
        edx = (edx << 11 | edx >>> 21) + eax;
        ecx += (eax ^ ebx ^ edx) + w[3] + -722521979;
        ecx = (ecx << 16 | ecx >>> 16) + edx;
        ebx += (eax ^ ecx ^ edx) + w[6] + 76029189;
        ebx = (ebx << 23 | ebx >>> 9) + ecx;
        eax += (ebx ^ ecx ^ edx) + w[9] + -640364487;
        eax = (eax << 4 | eax >>> 28) + ebx;
        edx += (eax ^ ebx ^ ecx) + w[12] + -421815835;
        edx = (edx << 11 | edx >>> 21) + eax;
        ecx += (eax ^ ebx ^ edx) + w[15] + 530742520;
        ecx = (ecx << 16 | ecx >>> 16) + edx;
        ebx += (eax ^ ecx ^ edx) + w[2] + -995338651;
        ebx = (ebx << 23 | ebx >>> 9) + ecx;
        eax += (ecx ^ (ebx | ~edx)) + w[0] + -198630844;
        eax = (eax << 6 | eax >>> 26) + ebx;
        edx += (ebx ^ (eax | ~ecx)) + w[7] + 1126891415;
        edx = (edx << 10 | edx >>> 22) + eax;
        ecx += (eax ^ (edx | ~ebx)) + w[14] + -1416354905;
        ecx = (ecx << 15 | ecx >>> 17) + edx;
        ebx += (edx ^ (ecx | ~eax)) + w[5] + -57434055;
        ebx = (ebx << 21 | ebx >>> 11) + ecx;
        eax += (ecx ^ (ebx | ~edx)) + w[12] + 1700485571;
        eax = (eax << 6 | eax >>> 26) + ebx;
        edx += (ebx ^ (eax | ~ecx)) + w[3] + -1894986606;
        edx = (edx << 10 | edx >>> 22) + eax;
        ecx += (eax ^ (edx | ~ebx)) + w[10] + -1051523;
        ecx = (ecx << 15 | ecx >>> 17) + edx;
        ebx += (edx ^ (ecx | ~eax)) + w[1] + -2054922799;
        ebx = (ebx << 21 | ebx >>> 11) + ecx;
        eax += (ecx ^ (ebx | ~edx)) + w[8] + 1873313359;
        eax = (eax << 6 | eax >>> 26) + ebx;
        edx += (ebx ^ (eax | ~ecx)) + w[15] + -30611744;
        edx = (edx << 10 | edx >>> 22) + eax;
        ecx += (eax ^ (edx | ~ebx)) + w[6] + -1560198380;
        ecx = (ecx << 15 | ecx >>> 17) + edx;
        ebx += (edx ^ (ecx | ~eax)) + w[13] + 1309151649;
        ebx = (ebx << 21 | ebx >>> 11) + ecx;
        eax += (ecx ^ (ebx | ~edx)) + w[4] + -145523070;
        eax = (eax << 6 | eax >>> 26) + ebx;
        edx += (ebx ^ (eax | ~ecx)) + w[11] + -1120210379;
        edx = (edx << 10 | edx >>> 22) + eax;
        ecx += (eax ^ (edx | ~ebx)) + w[2] + 718787259;
        ecx = (ecx << 15 | ecx >>> 17) + edx;
        ebx += (edx ^ (ecx | ~eax)) + w[9] + -343485551;
        ebx = (ebx << 21 | ebx >>> 11) + ecx;
        Convert.lendian_int2byte(this.state, 0, this.H1 + eax);
        Convert.lendian_int2byte(this.state, 4, this.H2 + ebx);
        Convert.lendian_int2byte(this.state, 8, this.H3 + ecx);
        Convert.lendian_int2byte(this.state, 12, this.H4 + edx);
    }

    protected int pad(HashPadMode pmode) {
        HashPad.MD4Pad(this);
        return 1;
    }
}

