/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashMech;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.hash.StateMD4;
import com.cryptomathic.crypto.hash.StateMD5;
import com.cryptomathic.crypto.hash.StateMDC1;
import com.cryptomathic.crypto.hash.StateMDC2;
import com.cryptomathic.crypto.hash.StateMDC4;
import com.cryptomathic.crypto.hash.StateRIPEMD;
import com.cryptomathic.crypto.hash.StateRIPEMD128;
import com.cryptomathic.crypto.hash.StateRIPEMD160;
import com.cryptomathic.crypto.hash.StateSha;
import com.cryptomathic.crypto.hash.StateSha224;
import com.cryptomathic.crypto.hash.StateSha256;
import com.cryptomathic.crypto.hash.StateSha384;
import com.cryptomathic.crypto.hash.StateSha512;

public abstract class HashState {
    protected byte[] state;
    protected byte[] buffer;
    protected int buffer_size = 0;
    protected int counter = 0;
    protected int block_size;
    protected int hash_size;
    protected HashType hashtype;

    protected HashState() {
    }

    public static HashState start_hash(HashType hmode) throws HashException {
        HashState state = null;
        int ref = hmode.toInt();
        if (ref == HashType.MDC1.toInt()) {
            state = new StateMDC1();
        }
        if (ref == HashType.MDC2.toInt()) {
            state = new StateMDC2();
        }
        if (ref == HashType.MDC4.toInt()) {
            state = new StateMDC4();
        }
        if (ref == HashType.SHA.toInt()) {
            state = new StateSha();
        }
        if (ref == HashType.SHA224.toInt()) {
            state = new StateSha224();
        }
        if (ref == HashType.SHA256.toInt()) {
            state = new StateSha256();
        }
        if (ref == HashType.SHA384.toInt()) {
            state = new StateSha384();
        }
        if (ref == HashType.SHA512.toInt()) {
            state = new StateSha512();
        }
        if (ref == HashType.MD4.toInt()) {
            state = new StateMD4();
        }
        if (ref == HashType.MD5.toInt()) {
            state = new StateMD5();
        }
        if (ref == HashType.RIPEMD160.toInt()) {
            state = new StateRIPEMD160();
        }
        if (ref == HashType.RIPEMD.toInt()) {
            state = new StateRIPEMD();
        }
        if (ref == HashType.RIPEMD128.toInt()) {
            state = new StateRIPEMD128();
        }
        if (state == null) {
            throw new HashException("Unsupported hash algorithm");
        }
        return state;
    }

    public void do_hash(byte[] m, int offset, int len) {
        int j;
        int block_size = this.block_size;
        m = this.buffer_append(m, offset, len);
        len += this.buffer_size;
        for (j = 0; j < len / block_size; ++j) {
            this.hash(m, j * block_size);
        }
        this.counter += len / block_size;
        this.buffer_update(m, j * block_size, len - j * block_size);
    }

    public void do_hash(byte[] m) {
        this.do_hash(m, 0, m.length);
    }

    public byte[] stop_hash(HashPadMode pmode, byte[] m, int offset, int len) throws HashException {
        this.do_hash(m, offset, len);
        return this.stop_hash(pmode);
    }

    public byte[] stop_hash(HashPadMode pmode) throws HashException {
        block3: {
            try {
                if (this.pad(pmode) == 1) {
                    byte[] dummy = new byte[]{};
                    this.do_hash(dummy, 0, 0);
                }
            }
            catch (HashException e) {
                if (e.toString().compareTo("MDC") == 0) break block3;
                throw new HashException("Invalid padding mode with MDCx");
            }
        }
        byte[] b = new byte[this.hash_size];
        System.arraycopy(this.state, 0, b, 0, this.hash_size);
        return b;
    }

    byte[] stop_hash_nopad(HashPadMode pmode) throws HashException {
        byte[] b = new byte[this.hash_size];
        System.arraycopy(this.state, 0, b, 0, this.hash_size);
        return b;
    }

    private byte[] buffer_append(byte[] m, int offset, int len) {
        byte[] res = new byte[len + this.buffer_size];
        System.arraycopy(this.buffer, 0, res, 0, this.buffer_size);
        System.arraycopy(m, offset, res, this.buffer_size, len);
        return res;
    }

    private void buffer_update(byte[] m, int offset, int len) {
        System.arraycopy(m, offset, this.buffer, 0, len);
        this.buffer_size = len;
    }

    abstract void hash(byte[] var1, int var2);

    abstract int pad(HashPadMode var1) throws HashException;

    public static HashState start_hmac(HashType hmode, byte[] key) throws HashException {
        HashState hstate = HashState.start_hash(hmode);
        byte[] ipad = new byte[hstate.block_size + hstate.state.length];
        if (key.length > hstate.block_size) {
            byte[] hashedkey = HashMech.hash_mes(hmode, HashPadMode.NOPAD, key, key.length);
            System.arraycopy(hashedkey, 0, ipad, 0, hashedkey.length);
        } else {
            System.arraycopy(key, 0, ipad, 0, key.length);
        }
        int i = 0;
        while (i < hstate.block_size) {
            int n = i++;
            ipad[n] = (byte)(ipad[n] ^ 0x36);
        }
        hstate.do_hash(ipad, 0, hstate.block_size);
        return hstate;
    }

    public void do_hmac(byte[] m, int offset, int len) {
        this.do_hash(m, offset, len);
    }

    public byte[] stop_hmac(byte[] m, int offset, int len, byte[] key) throws HashException {
        byte[] result = this.stop_hash(HashPadMode.NOPAD, m, offset, len);
        HashState hstate = HashState.start_hash(this.hashtype);
        byte[] opad = new byte[hstate.block_size + hstate.state.length];
        if (key.length > hstate.block_size) {
            byte[] hashedkey = HashMech.hash_mes(this.hashtype, HashPadMode.NOPAD, key, key.length);
            System.arraycopy(hashedkey, 0, opad, 0, hashedkey.length);
        } else {
            System.arraycopy(key, 0, opad, 0, key.length);
        }
        int i = 0;
        while (i < hstate.block_size) {
            int n = i++;
            opad[n] = (byte)(opad[n] ^ 0x5C);
        }
        System.arraycopy(result, 0, opad, hstate.block_size, result.length);
        return hstate.stop_hash(HashPadMode.NOPAD, opad, 0, hstate.block_size + result.length);
    }
}

