/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.util.Convert;

class HashPad {
    HashPad() {
    }

    protected static void MDCPad(HashState state) {
        byte[] res = new byte[16];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        res[state.buffer_size] = -128;
        for (int i = state.buffer_size + 1; i < 12; ++i) {
            res[i] = 0;
        }
        Convert.bendian_int2byte(res, 12, 8 * (8 * state.counter + state.buffer_size));
        System.arraycopy(res, 0, state.buffer, 0, 16);
        state.buffer_size = 16;
    }

    protected static void MDCPadFF16(HashState state) {
        byte[] res = new byte[8];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        for (int i = state.buffer_size; i < res.length - 1; ++i) {
            res[i] = -1;
        }
        res[res.length - 1] = (byte)(res.length - state.buffer_size);
        System.arraycopy(res, 0, state.buffer, 0, res.length);
        state.buffer_size = res.length;
    }

    protected static void MDCPadMethod1(HashState state) {
        if (state.buffer_size == 0) {
            return;
        }
        byte[] res = new byte[8];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        for (int i = state.buffer_size; i < res.length; ++i) {
            res[i] = 0;
        }
        System.arraycopy(res, 0, state.buffer, 0, res.length);
        state.buffer_size = res.length;
    }

    protected static void MDCPadMethod2(HashState state) {
        byte[] res = new byte[8];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        res[state.buffer_size] = -128;
        for (int i = state.buffer_size + 1; i < res.length; ++i) {
            res[i] = 0;
        }
        System.arraycopy(res, 0, state.buffer, 0, res.length);
        state.buffer_size = res.length;
    }

    protected static void MD4Pad(HashState state) {
        int i;
        int limit = state.buffer_size < 56 ? 56 : 120;
        byte[] res = new byte[limit + 8];
        byte[] b8 = new byte[8];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        res[state.buffer_size] = -128;
        for (i = state.buffer_size + 1; i < limit; ++i) {
            res[i] = 0;
        }
        Convert.lendian_int2byte(b8, 0, 8 * (state.counter * state.block_size + state.buffer_size));
        b8[4] = 0;
        b8[5] = 0;
        b8[6] = 0;
        b8[7] = 0;
        System.arraycopy(b8, 0, res, i, 8);
        System.arraycopy(res, 0, state.buffer, 0, limit + 8);
        state.buffer_size = limit + 8;
    }

    protected static void MD5Pad(HashState state) {
        HashPad.MD4Pad(state);
    }

    protected static void RIPEMD160Pad(HashState state) {
        HashPad.MD4Pad(state);
    }

    protected static void RIPEMDPad(HashState state) {
        HashPad.MD4Pad(state);
    }

    protected static void RIPEMD128Pad(HashState state) {
        HashPad.MD4Pad(state);
    }

    protected static void SHAPad(HashState state) {
        int i;
        int limit = state.buffer_size < 56 ? 60 : 124;
        byte[] res = new byte[limit + 4];
        byte[] b4 = new byte[4];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        res[state.buffer_size] = -128;
        for (i = state.buffer_size + 1; i < limit; ++i) {
            res[i] = 0;
        }
        Convert.bendian_int2byte(b4, 0, 8 * (state.counter * state.block_size + state.buffer_size));
        System.arraycopy(b4, 0, res, i, 4);
        System.arraycopy(res, 0, state.buffer, 0, limit + 4);
        state.buffer_size = limit + 4;
    }

    protected static void SHA512Pad(HashState state) {
        int i;
        int limit = state.buffer_size < 112 ? 112 : 240;
        byte[] res = new byte[limit + 16];
        byte[] b4 = new byte[4];
        System.arraycopy(state.buffer, 0, res, 0, state.buffer_size);
        res[state.buffer_size] = -128;
        for (i = state.buffer_size + 1; i < limit; ++i) {
            res[i] = 0;
        }
        while (i < limit + 8 + 4) {
            res[i] = 0;
            ++i;
        }
        Convert.bendian_int2byte(b4, 0, 8 * (state.counter * state.block_size + state.buffer_size));
        System.arraycopy(b4, 0, res, i, 4);
        System.arraycopy(res, 0, state.buffer, 0, limit + 16);
        state.buffer_size = limit + 16;
    }
}

