/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;
import java.util.Random;

public class FIPS_Derived_Random
extends Random {
    private static final long serialVersionUID = 1L;
    byte[] xj;
    byte[] XKEY;
    int counter;

    public FIPS_Derived_Random(byte[] seed) {
        this.XKEY = new byte[seed.length];
        if (seed.length < 20 || seed.length > 64) {
            throw new RuntimeException("length of seed out of range");
        }
        System.arraycopy(seed, 0, this.XKEY, 0, seed.length);
        this.update();
    }

    private void update() {
        this.xj = FIPS_Derived_Random.G(this.XKEY);
        BigInteger temp = BigInteger.ONE.add(new BigInteger(this.XKEY)).add(new BigInteger(this.xj));
        System.arraycopy(temp.toByteArray(), 0, this.XKEY, 0, this.XKEY.length);
        this.counter = 0;
    }

    protected int next(int bits) {
        if (this.counter + 4 > this.xj.length) {
            this.update();
        }
        int res = this.xj[this.counter] & 0xFF | this.xj[this.counter + 1] << 8 & 0xFF00 | this.xj[this.counter + 2] << 16 & 0xFF0000 | this.xj[this.counter + 3] << 24 & 0xFF000000;
        this.counter += 4;
        return res;
    }

    public static BigInteger Generate_random(BigInteger n, byte[] seed) {
        BigInteger temp;
        ByteArray res = new ByteArray();
        byte[] XKEY = new byte[seed.length];
        if (seed.length < 20 || seed.length > 64) {
            throw new RuntimeException("length of seed out of range");
        }
        int s = n.bitLength();
        int f = (s + 159) / 160;
        System.arraycopy(seed, 0, XKEY, 0, seed.length);
        for (int j = 1; j <= f; ++j) {
            byte[] xj = FIPS_Derived_Random.G(XKEY);
            res.append(xj);
            temp = BigInteger.ONE.add(new BigInteger(XKEY)).add(new BigInteger(xj));
            System.arraycopy(temp.toByteArray(), 0, XKEY, 0, seed.length);
        }
        temp = new BigInteger(res.toByteArray()).mod(n.subtract(BigInteger.ONE)).add(BigInteger.ONE);
        return temp;
    }

    private static byte[] G(byte[] c) {
        byte[] msg = new byte[64];
        System.arraycopy(c, 0, msg, 0, c.length);
        try {
            HashState hashstate = HashState.start_hash(HashType.SHA);
            hashstate.do_hash(msg);
            return hashstate.stop_hash_nopad(HashPadMode.NOPAD);
        }
        catch (HashException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

