/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.des;

import com.cryptomathic.crypto.des.DesException;
import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.des.DesMode;
import com.cryptomathic.crypto.des.DesState;
import com.cryptomathic.crypto.des.DesType;

class DesStateDes
extends DesState {
    static byte[] zero8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    static byte[] zero16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] key;
    private int[] ANSIMAC = null;

    protected DesStateDes(DesType destype, DesMode mode) {
        super(destype, mode);
    }

    protected void makekeys(byte[] key) throws DesException {
        if (this.mode.toInt() != DesMode.ANSIMAC.toInt()) {
            byte[] tmp = new byte[8];
            if (key.length < 8) {
                throw new DesException("Invalid keys for DES/" + this.mode.toString());
            }
            System.arraycopy(key, 0, tmp, 0, 8);
            this.key = null;
            this.key = DesKernel.des_make_keys(tmp);
            tmp = null;
        } else {
            byte[] tmp = new byte[8];
            if (key.length < 8) {
                throw new DesException("Invalid key for DES/" + this.mode.toString());
            }
            System.arraycopy(key, 0, tmp, 0, 8);
            this.key = DesKernel.des_make_keys(tmp);
            System.arraycopy(key, 8, tmp, 0, 8);
            this.ANSIMAC = DesKernel.des_make_keys(tmp);
            Object var2_3 = null;
        }
    }

    protected void change() {
        int[] tmp = this.key;
        this.key = this.ANSIMAC;
        this.ANSIMAC = tmp;
        tmp = null;
    }

    protected byte[] encrypt(byte[] in, int offs) {
        return DesKernel.des_encrypt(this.key, in, offs);
    }

    protected byte[] decrypt(byte[] in, int offs) {
        return DesKernel.des_decrypt(this.key, in, offs);
    }

    protected void makekeys_zero() throws DesException {
        if (this.mode.toInt() == DesMode.ANSIMAC.toInt()) {
            this.makekeys(zero16);
        } else {
            this.makekeys(zero8);
        }
    }

    protected void XORkeys() throws DesException {
        int i;
        byte[] tmp = new byte[8];
        byte[] key = new byte[128];
        System.arraycopy(this.key, 0, key, 0, 128);
        for (i = 0; i < 8; ++i) {
            tmp[i] = -16;
        }
        this.makekeys(tmp);
        for (i = 0; i < 128; ++i) {
            int n = i;
            this.key[n] = this.key[n] ^ key[i];
        }
    }

    protected byte[] getKeys() {
        byte[] res = new byte[128];
        System.arraycopy(this.key, 0, res, 0, 128);
        return res;
    }

    protected void setKeys(byte[] keys) {
        System.arraycopy(keys, 0, this.key, 0, 128);
    }
}

