/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.des;

import com.cryptomathic.crypto.des.DesException;
import com.cryptomathic.crypto.des.DesMode;
import com.cryptomathic.crypto.des.DesState3Des;
import com.cryptomathic.crypto.des.DesStateDes;
import com.cryptomathic.crypto.des.DesType;
import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.crypto.util.Convert;

public abstract class DesState {
    protected DesType destype;
    protected DesMode mode;
    protected int counter;
    protected byte[] iv;
    protected byte[] buffer;
    protected int buffer_size;

    protected DesState(DesType destype, DesMode mode) {
        this.destype = destype;
        this.mode = mode;
        this.iv = new byte[8];
        this.buffer = new byte[8];
        this.buffer_size = 0;
    }

    public static DesState des_start_mode(DesType destype, DesMode mode, byte[] key, byte[] iv) throws DesException {
        DesState state;
        byte[] zero_iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        int ref = destype.toInt();
        if (ref == DesType.DES3.toInt()) {
            if (mode.toInt() == DesMode.ANSIMAC.toInt() || mode.toInt() == DesMode.ANSIMAC8.toInt()) {
                throw new DesException("Cannot use " + mode.toString() + " with triple DES");
            }
            state = new DesState3Des(destype, mode);
        } else if (ref == DesType.DES.toInt()) {
            state = new DesStateDes(destype, mode);
        } else {
            throw new DesException("Unsupported DES type: " + destype.toString());
        }
        ((DesState)state).makekeys(key);
        ref = mode.toInt();
        if (ref != DesMode.ECBE.toInt() && ref != DesMode.ECBD.toInt()) {
            if (ref == DesMode.CBCE.toInt() || ref == DesMode.CBCD.toInt() || ref == DesMode.CFBE.toInt() || ref == DesMode.CFBD.toInt() || ref == DesMode.CFB64E.toInt() || ref == DesMode.CFB64D.toInt() || ref == DesMode.OFB.toInt()) {
                if (iv.length < 8) {
                    throw new DesException("Invalid initialization vector");
                }
                System.arraycopy(iv, 0, state.iv, 0, 8);
            } else if (ref == DesMode.MAC.toInt()) {
                System.arraycopy(zero_iv, 0, state.iv, 0, 8);
            } else if (ref == DesMode.ANSIMAC.toInt() || ref == DesMode.ANSIMAC8.toInt()) {
                System.arraycopy(zero_iv, 0, state.iv, 0, 8);
            } else if (ref == DesMode.RIPEMAC.toInt()) {
                System.arraycopy(zero_iv, 0, state.iv, 0, 8);
                state.counter = 0;
            } else {
                throw new DesException("Unsupported DES mode : " + mode.toString());
            }
        }
        return state;
    }

    public void des_do_mode(byte[] m, byte[] c, int offset, int len0, int coffset) {
        int ref = this.mode.toInt();
        if (ref == DesMode.ECBE.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            for (int j = 0; j < len / 8; ++j) {
                System.arraycopy(this.encrypt(m, j * 8), 0, c, j * 8 + coffset, 8);
            }
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.ECBD.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            for (int j = 0; j < len / 8; ++j) {
                System.arraycopy(this.decrypt(m, j * 8), 0, c, j * 8 + coffset, 8);
            }
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.CBCE.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            byte[] iv = new byte[8];
            System.arraycopy(this.iv, 0, iv, 0, 8);
            for (int j = 0; j < len / 8; ++j) {
                for (int i = 0; i < 8; ++i) {
                    c[j * 8 + coffset + i] = (byte)(m[j * 8 + i] ^ iv[i]);
                }
                System.arraycopy(this.encrypt(c, j * 8 + coffset), 0, c, j * 8 + coffset, 8);
                System.arraycopy(c, j * 8 + coffset, iv, 0, 8);
            }
            System.arraycopy(iv, 0, this.iv, 0, 8);
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.CBCD.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            byte[] iv = new byte[8];
            byte[] tmp = new byte[8];
            System.arraycopy(this.iv, 0, iv, 0, 8);
            for (int j = 0; j < len / 8; ++j) {
                System.arraycopy(m, j * 8, tmp, 0, 8);
                System.arraycopy(this.decrypt(m, j * 8), 0, c, j * 8 + coffset, 8);
                for (int i = 0; i < 8; ++i) {
                    int n = j * 8 + coffset + i;
                    c[n] = (byte)(c[n] ^ iv[i]);
                }
                System.arraycopy(tmp, 0, iv, 0, 8);
            }
            System.arraycopy(iv, 0, this.iv, 0, 8);
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.CFBE.toInt()) {
            byte[] tmp = new byte[8];
            int len = len0;
            for (int j = 0; j < len; ++j) {
                System.arraycopy(this.encrypt(this.iv, 0), 0, tmp, 0, 8);
                c[j + coffset] = (byte)(m[j + offset] ^ tmp[0]);
                for (int i = 0; i < 7; ++i) {
                    this.iv[i] = this.iv[i + 1];
                }
                this.iv[7] = c[j + coffset];
            }
        } else if (ref == DesMode.CFBD.toInt()) {
            byte[] tmp = new byte[8];
            int len = len0;
            for (int j = 0; j < len; ++j) {
                System.arraycopy(this.encrypt(this.iv, 0), 0, tmp, 0, 8);
                c[j + coffset] = (byte)(m[j + offset] ^ tmp[0]);
                for (int i = 0; i < 7; ++i) {
                    this.iv[i] = this.iv[i + 1];
                }
                this.iv[7] = m[j + offset];
            }
        } else if (ref == DesMode.OFB.toInt()) {
            int len = len0;
            for (int j = 0; j < len; ++j) {
                System.arraycopy(this.encrypt(this.iv, 0), 0, this.iv, 0, 8);
                c[j + coffset] = (byte)(this.iv[0] ^ m[j + offset]);
            }
        } else if (ref == DesMode.CFB64E.toInt()) {
            byte[] tmp = new byte[8];
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            for (int j = 0; j < len / 8; ++j) {
                System.arraycopy(this.encrypt(this.iv, 0), 0, tmp, 0, 8);
                for (int i = 0; i < 8; ++i) {
                    c[j * 8 + coffset + i] = (byte)(m[j * 8 + i] ^ tmp[i]);
                }
                System.arraycopy(c, j * 8 + coffset, this.iv, 0, 8);
            }
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.CFB64D.toInt()) {
            byte[] tmp = new byte[8];
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            for (int j = 0; j < len / 8; ++j) {
                System.arraycopy(this.encrypt(this.iv, 0), 0, tmp, 0, 8);
                for (int i = 0; i < 8; ++i) {
                    c[j * 8 + coffset + i] = (byte)(m[j * 8 + i] ^ tmp[i]);
                }
                System.arraycopy(m, j * 8, this.iv, 0, 8);
            }
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.MAC.toInt() || ref == DesMode.ANSIMAC.toInt() || ref == DesMode.ANSIMAC8.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            for (int j = 0; j < len / 8; ++j) {
                for (int i = 0; i < 8; ++i) {
                    int n = i;
                    this.iv[n] = (byte)(this.iv[n] ^ m[j * 8 + i]);
                }
                System.arraycopy(this.encrypt(this.iv, 0), 0, this.iv, 0, 8);
            }
            this.buffer_update(m, len - residue, residue);
        } else if (ref == DesMode.RIPEMAC.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            for (int j = 0; j < len / 8; ++j) {
                int i;
                for (i = 0; i < 8; ++i) {
                    int n = i;
                    this.iv[n] = (byte)(this.iv[n] ^ m[j * 8 + i]);
                }
                System.arraycopy(this.encrypt(this.iv, 0), 0, this.iv, 0, 8);
                for (i = 0; i < 8; ++i) {
                    int n = i;
                    this.iv[n] = (byte)(this.iv[n] ^ m[j * 8 + i]);
                }
            }
            this.buffer_update(m, len - residue, residue);
            this.counter += len / 8;
        }
    }

    public int des_stop_mode(PadMode pmode, byte[] m, byte[] c, int offset, int len0, int coffset) throws DesException {
        int rlen = 0;
        byte[] tmp = new byte[16];
        int ref = this.mode.toInt();
        if (ref == DesMode.ECBE.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            this.buffer_size = 0;
            if (len >= 8) {
                this.des_do_mode(m, c, 0, len - residue, coffset);
                coffset += len - residue;
                rlen += len - residue;
            }
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                System.arraycopy(m, len - residue, tmp, 0, residue);
                if (Pad.pad(tmp, residue, 8, pmode) == 1) {
                    System.arraycopy(this.encrypt(tmp, 0), 0, c, coffset, 8);
                    rlen += 8;
                }
            }
        } else if (ref == DesMode.ECBD.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            if (residue != 0) {
                throw new DesException("Number of bytes not a multiple of 8.");
            }
            m = this.buffer_append(m, offset, len0);
            this.buffer_size = 0;
            rlen = 0;
            if (len > 0) {
                if (len > 8) {
                    this.des_do_mode(m, c, 0, len - 8, coffset);
                    coffset += len - 8;
                }
                System.arraycopy(this.decrypt(m, 0), 0, tmp, 0, 8);
                if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                    try {
                        rlen = Pad.unpad(tmp, 8, pmode);
                    }
                    catch (EBadPadding e) {
                        throw new DesException("Bad padding");
                    }
                } else {
                    rlen = 8;
                }
                System.arraycopy(tmp, 0, c, coffset, rlen);
            } else {
                rlen = 8;
            }
            rlen = len - 8 + rlen;
        } else if (ref == DesMode.CBCE.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            m = this.buffer_append(m, offset, len0);
            this.buffer_size = 0;
            rlen = 0;
            if (len >= 8) {
                this.des_do_mode(m, c, 0, len - residue, coffset);
                coffset += len - residue;
                rlen += len - residue;
            }
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                System.arraycopy(m, len - residue, tmp, 0, residue);
                if (Pad.pad(tmp, residue, 8, pmode) == 1) {
                    byte[] iv = this.iv;
                    for (int i = 0; i < 8; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ iv[i]);
                    }
                    System.arraycopy(this.encrypt(tmp, 0), 0, c, coffset, 8);
                    System.arraycopy(c, coffset, iv, 0, 8);
                    rlen += 8;
                }
            }
        } else if (ref == DesMode.CBCD.toInt()) {
            int len = this.buffer_size + len0;
            int residue = len % 8;
            if (residue != 0) {
                throw new DesException("Number of bytes not a multiple of 8.");
            }
            m = this.buffer_append(m, offset, len0);
            this.buffer_size = 0;
            rlen = 0;
            if (len > 0) {
                if (len > 8) {
                    this.des_do_mode(m, c, 0, len - 8, coffset);
                }
                coffset += len;
                if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                    System.arraycopy(this.decrypt(m, len - 8), 0, tmp, 0, 8);
                    for (int i = 0; i < 8; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ this.iv[i]);
                    }
                    try {
                        rlen = Pad.unpad(tmp, 8, pmode);
                    }
                    catch (EBadPadding e) {
                        throw new DesException("Bad padding");
                    }
                    System.arraycopy(tmp, 0, c, coffset - 8, rlen);
                } else {
                    System.arraycopy(this.decrypt(m, len - 8), 0, tmp, 0, 8);
                    for (int i = 0; i < 8; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ this.iv[i]);
                    }
                    System.arraycopy(tmp, 0, c, coffset - 8, 8);
                    rlen = 8;
                }
                rlen = len - 8 + rlen;
            } else {
                rlen = 0;
            }
        } else if (ref == DesMode.CFB64E.toInt()) {
            int len;
            rlen = len = this.buffer_size + len0;
            if (len > 0) {
                m = this.buffer_append(m, offset, len0);
                this.buffer_size = 0;
                System.arraycopy(m, 0, tmp, 0, len);
                int i = len;
                while (i % 8 != 0) {
                    tmp[i] = 0;
                    ++i;
                }
                this.des_do_mode(tmp, tmp, 0, i, 0);
                System.arraycopy(tmp, 0, c, coffset, len);
            }
        } else if (ref == DesMode.CFB64D.toInt()) {
            int len;
            rlen = len = this.buffer_size + len0;
            if (len > 0) {
                m = this.buffer_append(m, offset, len0);
                this.buffer_size = 0;
                System.arraycopy(m, 0, tmp, 0, len);
                int i = len;
                while (i % 8 != 0) {
                    tmp[i] = 0;
                    ++i;
                }
                this.des_do_mode(tmp, tmp, 0, i, 0);
                System.arraycopy(tmp, 0, c, coffset, len);
            }
        } else if (ref != DesMode.CFBE.toInt() && ref != DesMode.CFBD.toInt() && ref != DesMode.OFB.toInt()) {
            if (ref == DesMode.MAC.toInt() || ref == DesMode.ANSIMAC.toInt() || ref == DesMode.ANSIMAC8.toInt()) {
                if (ref != DesMode.MAC.toInt()) {
                    if (!(this instanceof DesStateDes)) {
                        throw new DesException("Must use DES with mode " + this.mode.toString());
                    }
                    if (pmode.toInt() != PadMode.OPAD.toInt()) {
                        throw new DesException("Must pad with OPAD with mode " + this.mode.toString());
                    }
                }
                int len = this.buffer_size + len0;
                int residue = len % 8;
                m = this.buffer_append(m, offset, len0);
                this.buffer_size = 0;
                if (len >= 8) {
                    this.des_do_mode(m, c, 0, len - residue, coffset);
                }
                if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                    System.arraycopy(m, len - residue, tmp, 0, residue);
                    if (Pad.pad(tmp, residue, 8, pmode) == 1) {
                        for (int i = 0; i < 8; ++i) {
                            int n = i;
                            tmp[n] = (byte)(tmp[n] ^ this.iv[i]);
                        }
                        System.arraycopy(this.encrypt(tmp, 0), 0, c, coffset, 8);
                    } else {
                        System.arraycopy(this.iv, 0, c, coffset, 8);
                    }
                }
                if (ref == DesMode.ANSIMAC.toInt()) {
                    ((DesStateDes)this).change();
                    System.arraycopy(this.decrypt(c, coffset), 0, c, coffset, 8);
                    ((DesStateDes)this).change();
                    System.arraycopy(this.encrypt(c, coffset), 0, c, coffset, 8);
                }
                rlen = 8;
            } else if (ref == DesMode.RIPEMAC.toInt()) {
                int len = this.buffer_size + len0;
                int residue = len % 8;
                m = this.buffer_append(m, offset, len0);
                this.buffer_size = 0;
                if (len >= 8) {
                    this.des_do_mode(m, c, 0, len - residue, coffset);
                }
                System.arraycopy(m, len - residue, tmp, 0, residue);
                Pad.pad(tmp, residue, 8, PadMode.MDCPAD);
                int original_length = 8 * (this.counter * 8 + residue);
                Convert.bendian_int2byte(tmp, 12, original_length);
                this.des_do_mode(tmp, c, 0, 16, coffset);
                this.XORkeys();
                System.arraycopy(this.encrypt(this.iv, 0), 0, c, coffset, 8);
                rlen = 8;
            }
        }
        this.makekeys_zero();
        return rlen;
    }

    private byte[] buffer_append(byte[] m, int offset, int len) {
        byte[] res = new byte[len + this.buffer_size];
        System.arraycopy(this.buffer, 0, res, 0, this.buffer_size);
        System.arraycopy(m, offset, res, this.buffer_size, len);
        return res;
    }

    private void buffer_update(byte[] m, int offset, int len) {
        System.arraycopy(m, offset, this.buffer, 0, len);
        this.buffer_size = len;
    }

    abstract void makekeys(byte[] var1) throws DesException;

    abstract byte[] encrypt(byte[] var1, int var2);

    abstract byte[] decrypt(byte[] var1, int var2);

    abstract void makekeys_zero() throws DesException;

    abstract void XORkeys() throws DesException;

    abstract byte[] getKeys();

    abstract void setKeys(byte[] var1);
}

