/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.Pc2b;
import com.cryptomathic.crypto.conv.Sboxp;

final class DesKernel {
    static int[] Shift = new int[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
    static int[] Shift_28 = new int[]{27, 27, 26, 26, 26, 26, 26, 26, 27, 26, 26, 26, 26, 26, 26, 27};

    DesKernel() {
    }

    public static int[] des_make_keys(byte[] k) {
        int[] K = new int[32];
        int c = (k[3] & 0xFF) << 24;
        c |= (k[2] & 0xFF) << 16;
        c |= (k[1] & 0xFF) << 8;
        int d = (k[7] & 0xFF) << 24;
        d |= (k[6] & 0xFF) << 16;
        d |= (k[5] & 0xFF) << 8;
        int t = ((d |= k[4] & 0xFF) >>> 4 ^ (c |= k[0] & 0xFF)) & 0xF0F0F0F;
        c ^= t;
        d ^= t << 4;
        t = (c << 18 ^ c) & 0xCCCC0000;
        c ^= t ^ t >>> 18;
        t = (d << 18 ^ d) & 0xCCCC0000;
        d ^= t ^ t >>> 18;
        t = (d >>> 1 ^ c) & 0x55555555;
        c ^= t;
        d ^= t << 1;
        t = (c >>> 8 ^ d) & 0xFF00FF;
        d ^= t;
        c ^= t << 8;
        t = (d >>> 1 ^ c) & 0x55555555;
        d ^= t << 1;
        d = (d & 0xFF) << 16 | d & 0xFF00 | (d & 0xFF0000) >>> 16 | ((c ^= t) & 0xF0000000) >>> 4;
        c &= 0xFFFFFFF;
        for (int i = 0; i < 16; ++i) {
            c = c >>> Shift[i] | c << Shift_28[i];
            d = d >>> Shift[i] | d << Shift_28[i];
            int k0 = Pc2b.PC2b[0][c & 0xFF][0];
            int k1 = Pc2b.PC2b[0][c & 0xFF][1];
            k0 |= Pc2b.PC2b[4][d & 0xFF][0];
            k1 |= Pc2b.PC2b[4][d & 0xFF][1];
            k0 |= Pc2b.PC2b[1][c >>> 8 & 0xFF][0];
            k1 |= Pc2b.PC2b[1][c >>> 8 & 0xFF][1];
            k0 |= Pc2b.PC2b[5][d >>> 8 & 0xFF][0];
            k1 |= Pc2b.PC2b[5][d >>> 8 & 0xFF][1];
            k0 |= Pc2b.PC2b[2][c >>> 16 & 0xFF][0];
            k1 |= Pc2b.PC2b[2][c >>> 16 & 0xFF][1];
            k0 |= Pc2b.PC2b[6][d >>> 16 & 0xFF][0];
            k1 |= Pc2b.PC2b[6][d >>> 16 & 0xFF][1];
            k0 |= Pc2b.PC2b[3][c >>> 24][0];
            k1 |= Pc2b.PC2b[3][c >>> 24][1];
            K[2 * i] = k0 |= Pc2b.PC2b[7][d >>> 24][0];
            K[2 * i + 1] = k1 |= Pc2b.PC2b[7][d >>> 24][1];
        }
        return K;
    }

    public static void des_encrypt(int[] K, byte[] input, int ioffset, byte[] output, int ooffset) {
        int kpt = 0;
        int edx = (input[3 + ioffset] & 0xFF) << 24 | (input[2 + ioffset] & 0xFF) << 16 | (input[1 + ioffset] & 0xFF) << 8 | input[0 + ioffset] & 0xFF;
        int edi = (input[7 + ioffset] & 0xFF) << 24 | (input[6 + ioffset] & 0xFF) << 16 | (input[5 + ioffset] & 0xFF) << 8 | input[4 + ioffset] & 0xFF;
        int tmp = (edi >>> 4 ^ edx) & 0xF0F0F0F;
        edx ^= tmp;
        edi ^= tmp << 4;
        tmp = (edx >>> 16 ^ edi) & 0xFFFF;
        edi ^= tmp;
        edx ^= tmp << 16;
        tmp = (edi >>> 2 ^ edx) & 0x33333333;
        edx ^= tmp;
        edi ^= tmp << 2;
        tmp = (edx >>> 8 ^ edi) & 0xFF00FF;
        edi ^= tmp;
        edx ^= tmp << 8;
        tmp = (edi >>> 1 ^ edx) & 0x55555555;
        edx ^= tmp;
        edi ^= tmp << 1;
        edi = edi >>> 1 | edi << 31;
        edx = edx >>> 1 | edx << 31;
        for (int i = 0; i < 8; ++i) {
            int eax = (edx >>> 16 | edx << 16) ^ K[kpt];
            tmp = (edx << 20 | edx >>> 12) ^ K[++kpt];
            edi ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
            eax = (edi >>> 16 | edi << 16) ^ K[++kpt];
            tmp = (edi << 20 | edi >>> 12) ^ K[++kpt];
            ++kpt;
            edx ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
        }
        edi = edi << 1 | edi >>> 31;
        edx = edx << 1 | edx >>> 31;
        tmp = (edx >>> 1 ^ edi) & 0x55555555;
        edi ^= tmp;
        edx ^= tmp << 1;
        tmp = (edi >>> 8 ^ edx) & 0xFF00FF;
        edx ^= tmp;
        edi ^= tmp << 8;
        tmp = (edx >>> 2 ^ edi) & 0x33333333;
        edi ^= tmp;
        edx ^= tmp << 2;
        tmp = (edi >>> 16 ^ edx) & 0xFFFF;
        edx ^= tmp;
        edi ^= tmp << 16;
        tmp = (edx >>> 4 ^ edi) & 0xF0F0F0F;
        output[ooffset++] = (byte)(edi ^= tmp);
        output[ooffset++] = (byte)(edi >>> 8);
        output[ooffset++] = (byte)(edi >>> 16);
        output[ooffset++] = (byte)(edi >>> 24);
        output[ooffset++] = (byte)(edx ^= tmp << 4);
        output[ooffset++] = (byte)(edx >>> 8);
        output[ooffset++] = (byte)(edx >>> 16);
        output[ooffset] = (byte)(edx >>> 24);
    }

    public static byte[] des_encrypt(int[] K, byte[] input, int offs) {
        byte[] output = new byte[8];
        DesKernel.des_encrypt(K, input, offs, output, 0);
        return output;
    }

    public static void des_decrypt(int[] K, byte[] input, int ioffset, byte[] output, int ooffset) {
        int kpt = 32;
        int edx = (input[3 + ioffset] & 0xFF) << 24 | (input[2 + ioffset] & 0xFF) << 16 | (input[1 + ioffset] & 0xFF) << 8 | input[0 + ioffset] & 0xFF;
        int edi = (input[7 + ioffset] & 0xFF) << 24 | (input[6 + ioffset] & 0xFF) << 16 | (input[5 + ioffset] & 0xFF) << 8 | input[4 + ioffset] & 0xFF;
        int tmp = (edi >>> 4 ^ edx) & 0xF0F0F0F;
        edx ^= tmp;
        edi ^= tmp << 4;
        tmp = (edx >>> 16 ^ edi) & 0xFFFF;
        edi ^= tmp;
        edx ^= tmp << 16;
        tmp = (edi >>> 2 ^ edx) & 0x33333333;
        edx ^= tmp;
        edi ^= tmp << 2;
        tmp = (edx >>> 8 ^ edi) & 0xFF00FF;
        edi ^= tmp;
        edx ^= tmp << 8;
        tmp = (edi >>> 1 ^ edx) & 0x55555555;
        edx ^= tmp;
        edi ^= tmp << 1;
        edi = edi >>> 1 | edi << 31;
        edx = edx >>> 1 | edx << 31;
        for (int i = 0; i < 8; ++i) {
            int eax = (edx << 20 | edx >>> 12) ^ K[--kpt];
            tmp = (edx >>> 16 | edx << 16) ^ K[--kpt];
            edi ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
            eax = (edi << 20 | edi >>> 12) ^ K[--kpt];
            tmp = (edi >>> 16 | edi << 16) ^ K[--kpt];
            edx ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
        }
        edi = edi << 1 | edi >>> 31;
        edx = edx << 1 | edx >>> 31;
        tmp = (edx >>> 1 ^ edi) & 0x55555555;
        edi ^= tmp;
        edx ^= tmp << 1;
        tmp = (edi >>> 8 ^ edx) & 0xFF00FF;
        edx ^= tmp;
        edi ^= tmp << 8;
        tmp = (edx >>> 2 ^ edi) & 0x33333333;
        edi ^= tmp;
        edx ^= tmp << 2;
        tmp = (edi >>> 16 ^ edx) & 0xFFFF;
        edx ^= tmp;
        edi ^= tmp << 16;
        tmp = (edx >>> 4 ^ edi) & 0xF0F0F0F;
        output[ooffset++] = (byte)(edi ^= tmp);
        output[ooffset++] = (byte)(edi >>> 8);
        output[ooffset++] = (byte)(edi >>> 16);
        output[ooffset++] = (byte)(edi >>> 24);
        output[ooffset++] = (byte)(edx ^= tmp << 4);
        output[ooffset++] = (byte)(edx >>> 8);
        output[ooffset++] = (byte)(edx >>> 16);
        output[ooffset] = (byte)(edx >>> 24);
    }

    public static byte[] des_decrypt(int[] K, byte[] input, int offs) {
        byte[] output = new byte[8];
        DesKernel.des_decrypt(K, input, offs, output, 0);
        return output;
    }

    public static void des3_encrypt(int[] K1, int[] K2, byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des3_encrypt(K1, K2, K1, input, ioffset, output, ooffset);
    }

    public static void des3_encrypt(int[] K1, int[] K2, int[] K3, byte[] input, int ioffset, byte[] output, int ooffset) {
        int eax;
        int i;
        int kpt = 0;
        int edx = (input[3 + ioffset] & 0xFF) << 24 | (input[2 + ioffset] & 0xFF) << 16 | (input[1 + ioffset] & 0xFF) << 8 | input[0 + ioffset] & 0xFF;
        int edi = (input[7 + ioffset] & 0xFF) << 24 | (input[6 + ioffset] & 0xFF) << 16 | (input[5 + ioffset] & 0xFF) << 8 | input[4 + ioffset] & 0xFF;
        int tmp = (edi >>> 4 ^ edx) & 0xF0F0F0F;
        edx ^= tmp;
        edi ^= tmp << 4;
        tmp = (edx >>> 16 ^ edi) & 0xFFFF;
        edi ^= tmp;
        edx ^= tmp << 16;
        tmp = (edi >>> 2 ^ edx) & 0x33333333;
        edx ^= tmp;
        edi ^= tmp << 2;
        tmp = (edx >>> 8 ^ edi) & 0xFF00FF;
        edi ^= tmp;
        edx ^= tmp << 8;
        tmp = (edi >>> 1 ^ edx) & 0x55555555;
        edx ^= tmp;
        edi ^= tmp << 1;
        edi = edi >>> 1 | edi << 31;
        edx = edx >>> 1 | edx << 31;
        for (i = 0; i < 8; ++i) {
            eax = (edx >>> 16 | edx << 16) ^ K1[kpt];
            tmp = (edx << 20 | edx >>> 12) ^ K1[++kpt];
            edi ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
            eax = (edi >>> 16 | edi << 16) ^ K1[++kpt];
            tmp = (edi << 20 | edi >>> 12) ^ K1[++kpt];
            ++kpt;
            edx ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
        }
        for (i = 0; i < 8; ++i) {
            eax = (edi << 20 | edi >>> 12) ^ K2[--kpt];
            tmp = (edi >>> 16 | edi << 16) ^ K2[--kpt];
            edx ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
            eax = (edx << 20 | edx >>> 12) ^ K2[--kpt];
            tmp = (edx >>> 16 | edx << 16) ^ K2[--kpt];
            edi ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
        }
        for (i = 0; i < 8; ++i) {
            eax = (edx >>> 16 | edx << 16) ^ K3[kpt];
            tmp = (edx << 20 | edx >>> 12) ^ K3[++kpt];
            edi ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
            eax = (edi >>> 16 | edi << 16) ^ K3[++kpt];
            tmp = (edi << 20 | edi >>> 12) ^ K3[++kpt];
            ++kpt;
            edx ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
        }
        edi = edi << 1 | edi >>> 31;
        edx = edx << 1 | edx >>> 31;
        tmp = (edx >>> 1 ^ edi) & 0x55555555;
        edi ^= tmp;
        edx ^= tmp << 1;
        tmp = (edi >>> 8 ^ edx) & 0xFF00FF;
        edx ^= tmp;
        edi ^= tmp << 8;
        tmp = (edx >>> 2 ^ edi) & 0x33333333;
        edi ^= tmp;
        edx ^= tmp << 2;
        tmp = (edi >>> 16 ^ edx) & 0xFFFF;
        edx ^= tmp;
        edi ^= tmp << 16;
        tmp = (edx >>> 4 ^ edi) & 0xF0F0F0F;
        output[ooffset++] = (byte)(edi ^= tmp);
        output[ooffset++] = (byte)(edi >>> 8);
        output[ooffset++] = (byte)(edi >>> 16);
        output[ooffset++] = (byte)(edi >>> 24);
        output[ooffset++] = (byte)(edx ^= tmp << 4);
        output[ooffset++] = (byte)(edx >>> 8);
        output[ooffset++] = (byte)(edx >>> 16);
        output[ooffset] = (byte)(edx >>> 24);
    }

    public static void des3_decrypt(int[] K1, int[] K2, byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des3_decrypt(K1, K2, K1, input, ioffset, output, ooffset);
    }

    public static void des3_decrypt(int[] K1, int[] K2, int[] K3, byte[] input, int ioffset, byte[] output, int ooffset) {
        int eax;
        int i;
        int kpt = 32;
        int edx = (input[3 + ioffset] & 0xFF) << 24 | (input[2 + ioffset] & 0xFF) << 16 | (input[1 + ioffset] & 0xFF) << 8 | input[0 + ioffset] & 0xFF;
        int edi = (input[7 + ioffset] & 0xFF) << 24 | (input[6 + ioffset] & 0xFF) << 16 | (input[5 + ioffset] & 0xFF) << 8 | input[4 + ioffset] & 0xFF;
        int tmp = (edi >>> 4 ^ edx) & 0xF0F0F0F;
        edx ^= tmp;
        edi ^= tmp << 4;
        tmp = (edx >>> 16 ^ edi) & 0xFFFF;
        edi ^= tmp;
        edx ^= tmp << 16;
        tmp = (edi >>> 2 ^ edx) & 0x33333333;
        edx ^= tmp;
        edi ^= tmp << 2;
        tmp = (edx >>> 8 ^ edi) & 0xFF00FF;
        edi ^= tmp;
        edx ^= tmp << 8;
        tmp = (edi >>> 1 ^ edx) & 0x55555555;
        edx ^= tmp;
        edi ^= tmp << 1;
        edi = edi >>> 1 | edi << 31;
        edx = edx >>> 1 | edx << 31;
        for (i = 0; i < 8; ++i) {
            eax = (edx << 20 | edx >>> 12) ^ K3[--kpt];
            tmp = (edx >>> 16 | edx << 16) ^ K3[--kpt];
            edi ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
            eax = (edi << 20 | edi >>> 12) ^ K3[--kpt];
            tmp = (edi >>> 16 | edi << 16) ^ K3[--kpt];
            edx ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
        }
        for (i = 0; i < 8; ++i) {
            eax = (edi >>> 16 | edi << 16) ^ K2[kpt];
            tmp = (edi << 20 | edi >>> 12) ^ K2[++kpt];
            edx ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
            eax = (edx >>> 16 | edx << 16) ^ K2[++kpt];
            tmp = (edx << 20 | edx >>> 12) ^ K2[++kpt];
            ++kpt;
            edi ^= Sboxp.SBOX6[eax >>> 2 & 0x3F] ^ Sboxp.SBOX8[eax >>> 10 & 0x3F] ^ Sboxp.SBOX2[eax >>> 18 & 0x3F] ^ Sboxp.SBOX4[eax >>> 26 & 0x3F] ^ Sboxp.SBOX5[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX7[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX1[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX3[tmp >>> 26 & 0x3F];
        }
        for (i = 0; i < 8; ++i) {
            eax = (edx << 20 | edx >>> 12) ^ K1[--kpt];
            tmp = (edx >>> 16 | edx << 16) ^ K1[--kpt];
            edi ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
            eax = (edi << 20 | edi >>> 12) ^ K1[--kpt];
            tmp = (edi >>> 16 | edi << 16) ^ K1[--kpt];
            edx ^= Sboxp.SBOX5[eax >>> 2 & 0x3F] ^ Sboxp.SBOX7[eax >>> 10 & 0x3F] ^ Sboxp.SBOX1[eax >>> 18 & 0x3F] ^ Sboxp.SBOX3[eax >>> 26 & 0x3F] ^ Sboxp.SBOX6[tmp >>> 2 & 0x3F] ^ Sboxp.SBOX8[tmp >>> 10 & 0x3F] ^ Sboxp.SBOX2[tmp >>> 18 & 0x3F] ^ Sboxp.SBOX4[tmp >>> 26 & 0x3F];
        }
        edi = edi << 1 | edi >>> 31;
        edx = edx << 1 | edx >>> 31;
        tmp = (edx >>> 1 ^ edi) & 0x55555555;
        edi ^= tmp;
        edx ^= tmp << 1;
        tmp = (edi >>> 8 ^ edx) & 0xFF00FF;
        edx ^= tmp;
        edi ^= tmp << 8;
        tmp = (edx >>> 2 ^ edi) & 0x33333333;
        edi ^= tmp;
        edx ^= tmp << 2;
        tmp = (edi >>> 16 ^ edx) & 0xFFFF;
        edx ^= tmp;
        edi ^= tmp << 16;
        tmp = (edx >>> 4 ^ edi) & 0xF0F0F0F;
        output[ooffset++] = (byte)(edi ^= tmp);
        output[ooffset++] = (byte)(edi >>> 8);
        output[ooffset++] = (byte)(edi >>> 16);
        output[ooffset++] = (byte)(edi >>> 24);
        output[ooffset++] = (byte)(edx ^= tmp << 4);
        output[ooffset++] = (byte)(edx >>> 8);
        output[ooffset++] = (byte)(edx >>> 16);
        output[ooffset++] = (byte)(edx >>> 24);
    }
}

