/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.ConvException;
import com.cryptomathic.crypto.conv.ConvMode;
import com.cryptomathic.crypto.conv.ConvState;
import com.cryptomathic.crypto.conv.ConvType;
import com.cryptomathic.crypto.conv.DesKernel;

class ConvStateDes
extends ConvState {
    private int[] key;

    protected ConvStateDes(ConvType destype, ConvMode mode) {
        super(destype, mode);
    }

    protected void makekeys(byte[] key) throws ConvException {
        byte[] tmp = new byte[8];
        if (key.length != 8) {
            throw new ConvException("Invalid keys for DES/" + this.mode.toString());
        }
        System.arraycopy(key, 0, tmp, 0, 8);
        this.key = null;
        this.key = DesKernel.des_make_keys(tmp);
        tmp = null;
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des_encrypt(this.key, input, ioffset, output, ooffset);
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des_decrypt(this.key, input, ioffset, output, ooffset);
    }

    protected void makekeys_zero() throws ConvException {
        for (int i = 0; i < this.key.length; ++i) {
            this.key[i] = 0;
        }
    }

    void makekeys_encrypt(byte[] key) throws ConvException {
        this.makekeys(key);
    }

    void makekeys_decrypt(byte[] key) throws ConvException {
        this.makekeys(key);
    }

    int blocksize() {
        return 8;
    }
}

