/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.AesKernel;
import com.cryptomathic.crypto.conv.ConvException;
import com.cryptomathic.crypto.conv.ConvMode;
import com.cryptomathic.crypto.conv.ConvState;
import com.cryptomathic.crypto.conv.ConvType;

class ConvStateAes
extends ConvState {
    private int[][] key;

    protected ConvStateAes(ConvType convtype, ConvMode mode) {
        super(convtype, mode);
    }

    protected void makekeys_encrypt(byte[] key) throws ConvException {
        if (this.convtype == ConvType.AES) {
            this.key = AesKernel.makekeys_encrypt_128(key);
        } else if (this.convtype == ConvType.AES192) {
            this.key = AesKernel.makekeys_encrypt_192(key);
        } else if (this.convtype == ConvType.AES256) {
            this.key = AesKernel.makekeys_encrypt_256(key);
        }
    }

    protected void makekeys_decrypt(byte[] key) throws ConvException {
        if (this.convtype == ConvType.AES) {
            this.key = AesKernel.makekeys_decrypt_128(key);
        } else if (this.convtype == ConvType.AES192) {
            this.key = AesKernel.makekeys_decrypt_192(key);
        } else if (this.convtype == ConvType.AES256) {
            this.key = AesKernel.makekeys_decrypt_256(key);
        }
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        if (this.convtype == ConvType.AES) {
            AesKernel.encrypt_128(this.key, input, ioffset, output, ooffset);
        } else if (this.convtype == ConvType.AES192) {
            AesKernel.encrypt_192(this.key, input, ioffset, output, ooffset);
        } else if (this.convtype == ConvType.AES256) {
            AesKernel.encrypt_256(this.key, input, ioffset, output, ooffset);
        }
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        if (this.convtype == ConvType.AES) {
            AesKernel.decrypt_128(this.key, input, ioffset, output, ooffset);
        } else if (this.convtype == ConvType.AES192) {
            AesKernel.decrypt_192(this.key, input, ioffset, output, ooffset);
        } else if (this.convtype == ConvType.AES256) {
            AesKernel.decrypt_256(this.key, input, ioffset, output, ooffset);
        }
    }

    protected void makekeys_zero() throws ConvException {
        for (int i = 0; i < this.key.length; ++i) {
            for (int j = 0; j < this.key[i].length; ++j) {
                this.key[i][j] = 0;
            }
        }
    }

    int blocksize() {
        return 16;
    }
}

