/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.ConvException;
import com.cryptomathic.crypto.conv.ConvMode;
import com.cryptomathic.crypto.conv.ConvState;
import com.cryptomathic.crypto.conv.ConvType;
import com.cryptomathic.crypto.conv.DesKernel;

class ConvState3Des
extends ConvState {
    static byte[] zero16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] key1;
    private int[] key2;
    private int[] key3;

    protected ConvState3Des(ConvType destype, ConvMode mode) {
        super(destype, mode);
    }

    protected void makekeys(byte[] keys) throws ConvException {
        if (keys.length != 16 && keys.length != 24) {
            throw new ConvException("Invalid key triple DES");
        }
        byte[] tmp = new byte[8];
        System.arraycopy(keys, 0, tmp, 0, 8);
        this.key1 = DesKernel.des_make_keys(tmp);
        System.arraycopy(keys, 8, tmp, 0, 8);
        this.key2 = DesKernel.des_make_keys(tmp);
        if (keys.length == 24) {
            System.arraycopy(keys, 16, tmp, 0, 8);
            this.key3 = DesKernel.des_make_keys(tmp);
        } else {
            this.key3 = this.key1;
        }
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des3_encrypt(this.key1, this.key2, this.key3, input, ioffset, output, ooffset);
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des3_decrypt(this.key1, this.key2, this.key3, input, ioffset, output, ooffset);
    }

    protected void makekeys_zero() throws ConvException {
        int i;
        for (i = 0; i < this.key1.length; ++i) {
            this.key1[i] = 0;
        }
        for (i = 0; i < this.key2.length; ++i) {
            this.key2[i] = 0;
        }
        for (i = 0; i < this.key3.length; ++i) {
            this.key3[i] = 0;
        }
    }

    void makekeys_encrypt(byte[] key) throws ConvException {
        this.makekeys(key);
    }

    void makekeys_decrypt(byte[] key) throws ConvException {
        this.makekeys(key);
    }

    int blocksize() {
        return 8;
    }
}

