/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.aestbl;

public final class AesKernel {
    public static final int[][] makekeys_encrypt_util(byte[] key, int rounds) {
        int[] k = new int[key.length >>> 2];
        for (int i = 0; i < key.length >>> 2; ++i) {
            k[i] = AesKernel.qrunch(key, i << 2);
        }
        return AesKernel.KeyExpansion(k, rounds);
    }

    public static final int[][] makekeys_encrypt_128(byte[] key) {
        return AesKernel.makekeys_encrypt_util(key, 10);
    }

    public static final int[][] makekeys_encrypt_192(byte[] key) {
        return AesKernel.makekeys_encrypt_util(key, 12);
    }

    public static final int[][] makekeys_encrypt_256(byte[] key) {
        return AesKernel.makekeys_encrypt_util(key, 14);
    }

    public static final int[][] makekeys_decrypt_util(byte[] key, int rounds) {
        int[] k = new int[key.length >>> 2];
        for (int i = 0; i < key.length >>> 2; ++i) {
            k[i] = AesKernel.qrunch(key, i << 2);
        }
        int[][] result = AesKernel.KeyExpansion(k, rounds);
        AesKernel.KeyToDecryptionKey(result, rounds);
        return result;
    }

    public static final int[][] makekeys_decrypt_128(byte[] key) {
        return AesKernel.makekeys_decrypt_util(key, 10);
    }

    public static final int[][] makekeys_decrypt_192(byte[] key) {
        return AesKernel.makekeys_decrypt_util(key, 12);
    }

    public static final int[][] makekeys_decrypt_256(byte[] key) {
        return AesKernel.makekeys_decrypt_util(key, 14);
    }

    public static final void encrypt_128(int[][] keys, byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.LowLevelEncrypt(input, ioffset, output, ooffset, keys, 10);
    }

    public static final void decrypt_128(int[][] keys, byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.LowLevelDecrypt(input, ioffset, output, ooffset, keys, 10);
    }

    public static final void encrypt_192(int[][] keys, byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.LowLevelEncrypt(input, ioffset, output, ooffset, keys, 12);
    }

    public static final void decrypt_192(int[][] keys, byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.LowLevelDecrypt(input, ioffset, output, ooffset, keys, 12);
    }

    public static final void encrypt_256(int[][] keys, byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.LowLevelEncrypt(input, ioffset, output, ooffset, keys, 14);
    }

    public static final void decrypt_256(int[][] keys, byte[] input, int ioffset, byte[] output, int ooffset) {
        AesKernel.LowLevelDecrypt(input, ioffset, output, ooffset, keys, 14);
    }

    private static final int[][] KeyExpansion(int[] k, int rounds) {
        int j;
        int[][] roundkeys = new int[rounds + 1][4];
        int rconpointer = 0;
        int[] tk = new int[k.length];
        int KC = rounds - 6;
        for (j = KC - 1; j >= 0; --j) {
            tk[j] = k[j];
        }
        int r = 0;
        int t = 0;
        for (j = 0; j < KC && r < rounds + 1; ++j) {
            roundkeys[r][t] = tk[j];
            if (++t != 4) continue;
            ++r;
            t = 0;
        }
        while (r < rounds + 1) {
            int tkaux = tk[KC - 1];
            int tkaux1 = tk[0];
            tkaux1 ^= (aestbl.S[tkaux >>> 16 & 0xFF] & 0xFF) << 24;
            tkaux1 ^= (aestbl.S[tkaux >>> 8 & 0xFF] & 0xFF) << 16;
            tkaux1 ^= (aestbl.S[tkaux & 0xFF] & 0xFF) << 8;
            tkaux1 ^= aestbl.S[tkaux >>> 24] & 0xFF;
            tk[0] = tkaux1 ^= aestbl.rcon[rconpointer++] << 24;
            if (KC != 8) {
                for (j = 1; j < KC; ++j) {
                    int n = j;
                    tk[n] = tk[n] ^ tk[j - 1];
                }
            } else {
                for (j = 1; j < KC >> 1; ++j) {
                    int n = j;
                    tk[n] = tk[n] ^ tk[j - 1];
                }
                tkaux = tk[(KC >> 1) - 1];
                tkaux1 = tk[KC >> 1];
                tkaux1 ^= (aestbl.S[tkaux >> 24 & 0xFF] & 0xFF) << 24;
                tkaux1 ^= (aestbl.S[tkaux >> 16 & 0xFF] & 0xFF) << 16;
                tkaux1 ^= (aestbl.S[tkaux >> 8 & 0xFF] & 0xFF) << 8;
                tk[KC >> 1] = tkaux1 ^= aestbl.S[tkaux & 0xFF] & 0xFF;
                for (j = (KC >> 1) + 1; j < KC; ++j) {
                    int n = j;
                    tk[n] = tk[n] ^ tk[j - 1];
                }
            }
            for (j = 0; j < KC && r < rounds + 1; ++j) {
                roundkeys[r][t] = tk[j];
                if (++t != 4) continue;
                ++r;
                t = 0;
            }
        }
        return roundkeys;
    }

    private static final void KeyToDecryptionKey(int[][] roundkeys, int rounds) {
        for (int r = 1; r < rounds; ++r) {
            int aux = roundkeys[r][0];
            roundkeys[r][0] = aestbl.U1[aux >>> 24] ^ aestbl.U2[aux >>> 16 & 0xFF] ^ aestbl.U3[aux >>> 8 & 0xFF] ^ aestbl.U4[aux & 0xFF];
            aux = roundkeys[r][1];
            roundkeys[r][1] = aestbl.U1[aux >>> 24] ^ aestbl.U2[aux >>> 16 & 0xFF] ^ aestbl.U3[aux >>> 8 & 0xFF] ^ aestbl.U4[aux & 0xFF];
            aux = roundkeys[r][2];
            roundkeys[r][2] = aestbl.U1[aux >>> 24] ^ aestbl.U2[aux >>> 16 & 0xFF] ^ aestbl.U3[aux >>> 8 & 0xFF] ^ aestbl.U4[aux & 0xFF];
            aux = roundkeys[r][3];
            roundkeys[r][3] = aestbl.U1[aux >>> 24] ^ aestbl.U2[aux >>> 16 & 0xFF] ^ aestbl.U3[aux >>> 8 & 0xFF] ^ aestbl.U4[aux & 0xFF];
        }
    }

    private static final void LowLevelEncrypt(byte[] input, int oinput, byte[] output, int ooutput, int[][] keys, int rounds) {
        int r = 0;
        int[] aaux = new int[]{AesKernel.qrunch(input, oinput), AesKernel.qrunch(input, oinput + 4), AesKernel.qrunch(input, oinput + 8), AesKernel.qrunch(input, oinput + 12)};
        int temp0 = aaux[0] ^ keys[0][0];
        int temp1 = aaux[1] ^ keys[0][1];
        int temp2 = aaux[2] ^ keys[0][2];
        int temp3 = aaux[3] ^ keys[0][3];
        int baux0 = aestbl.T1[temp0 >>> 24] ^ aestbl.T2[temp1 >>> 16 & 0xFF] ^ aestbl.T3[temp2 >>> 8 & 0xFF] ^ aestbl.T4[temp3 & 0xFF];
        int baux1 = aestbl.T1[temp1 >>> 24] ^ aestbl.T2[temp2 >>> 16 & 0xFF] ^ aestbl.T3[temp3 >>> 8 & 0xFF] ^ aestbl.T4[temp0 & 0xFF];
        int baux2 = aestbl.T1[temp2 >>> 24] ^ aestbl.T2[temp3 >>> 16 & 0xFF] ^ aestbl.T3[temp0 >>> 8 & 0xFF] ^ aestbl.T4[temp1 & 0xFF];
        int baux3 = aestbl.T1[temp3 >>> 24] ^ aestbl.T2[temp0 >>> 16 & 0xFF] ^ aestbl.T3[temp1 >>> 8 & 0xFF] ^ aestbl.T4[temp2 & 0xFF];
        for (r = 1; r < rounds - 1; ++r) {
            temp0 = baux0 ^ keys[r][0];
            temp1 = baux1 ^ keys[r][1];
            temp2 = baux2 ^ keys[r][2];
            temp3 = baux3 ^ keys[r][3];
            baux0 = aestbl.T1[temp0 >>> 24] ^ aestbl.T2[temp1 >>> 16 & 0xFF] ^ aestbl.T3[temp2 >>> 8 & 0xFF] ^ aestbl.T4[temp3 & 0xFF];
            baux1 = aestbl.T1[temp1 >>> 24] ^ aestbl.T2[temp2 >>> 16 & 0xFF] ^ aestbl.T3[temp3 >>> 8 & 0xFF] ^ aestbl.T4[temp0 & 0xFF];
            baux2 = aestbl.T1[temp2 >>> 24] ^ aestbl.T2[temp3 >>> 16 & 0xFF] ^ aestbl.T3[temp0 >>> 8 & 0xFF] ^ aestbl.T4[temp1 & 0xFF];
            baux3 = aestbl.T1[temp3 >>> 24] ^ aestbl.T2[temp0 >>> 16 & 0xFF] ^ aestbl.T3[temp1 >>> 8 & 0xFF] ^ aestbl.T4[temp2 & 0xFF];
        }
        temp0 = baux0 ^ keys[rounds - 1][0];
        temp1 = baux1 ^ keys[rounds - 1][1];
        temp2 = baux2 ^ keys[rounds - 1][2];
        temp3 = baux3 ^ keys[rounds - 1][3];
        baux0 = (aestbl.T1[temp0 >>> 24] >>> 16 & 0xFF) << 24 | (aestbl.T1[temp1 >>> 16 & 0xFF] >>> 16 & 0xFF) << 16 | (aestbl.T1[temp2 >>> 8 & 0xFF] >>> 16 & 0xFF) << 8 | aestbl.T1[temp3 & 0xFF] >>> 16 & 0xFF;
        baux1 = (aestbl.T1[temp1 >>> 24] >>> 16 & 0xFF) << 24 | (aestbl.T1[temp2 >>> 16 & 0xFF] >>> 16 & 0xFF) << 16 | (aestbl.T1[temp3 >>> 8 & 0xFF] >>> 16 & 0xFF) << 8 | aestbl.T1[temp0 & 0xFF] >>> 16 & 0xFF;
        baux2 = (aestbl.T1[temp2 >>> 24] >>> 16 & 0xFF) << 24 | (aestbl.T1[temp3 >>> 16 & 0xFF] >>> 16 & 0xFF) << 16 | (aestbl.T1[temp0 >>> 8 & 0xFF] >>> 16 & 0xFF) << 8 | aestbl.T1[temp1 & 0xFF] >>> 16 & 0xFF;
        baux3 = (aestbl.T1[temp3 >>> 24] >>> 16 & 0xFF) << 24 | (aestbl.T1[temp0 >>> 16 & 0xFF] >>> 16 & 0xFF) << 16 | (aestbl.T1[temp1 >>> 8 & 0xFF] >>> 16 & 0xFF) << 8 | aestbl.T1[temp2 & 0xFF] >>> 16 & 0xFF;
        AesKernel.unqrunch(baux0 ^= keys[rounds][0], output, ooutput);
        AesKernel.unqrunch(baux1 ^= keys[rounds][1], output, ooutput + 4);
        AesKernel.unqrunch(baux2 ^= keys[rounds][2], output, ooutput + 8);
        AesKernel.unqrunch(baux3 ^= keys[rounds][3], output, ooutput + 12);
    }

    private static final void LowLevelDecrypt(byte[] input, int oinput, byte[] output, int ooutput, int[][] keys, int rounds) {
        int r = rounds;
        int[] aaux = new int[]{AesKernel.qrunch(input, oinput), AesKernel.qrunch(input, oinput + 4), AesKernel.qrunch(input, oinput + 8), AesKernel.qrunch(input, oinput + 12)};
        int temp0 = aaux[0] ^ keys[rounds][0];
        int temp1 = aaux[1] ^ keys[rounds][1];
        int temp2 = aaux[2] ^ keys[rounds][2];
        int temp3 = aaux[3] ^ keys[rounds][3];
        int baux0 = aestbl.T5[temp0 >>> 24] ^ aestbl.T6[temp3 >>> 16 & 0xFF] ^ aestbl.T7[temp2 >>> 8 & 0xFF] ^ aestbl.T8[temp1 & 0xFF];
        int baux1 = aestbl.T5[temp1 >>> 24] ^ aestbl.T6[temp0 >>> 16 & 0xFF] ^ aestbl.T7[temp3 >>> 8 & 0xFF] ^ aestbl.T8[temp2 & 0xFF];
        int baux2 = aestbl.T5[temp2 >>> 24] ^ aestbl.T6[temp1 >>> 16 & 0xFF] ^ aestbl.T7[temp0 >>> 8 & 0xFF] ^ aestbl.T8[temp3 & 0xFF];
        int baux3 = aestbl.T5[temp3 >>> 24] ^ aestbl.T6[temp2 >>> 16 & 0xFF] ^ aestbl.T7[temp1 >>> 8 & 0xFF] ^ aestbl.T8[temp0 & 0xFF];
        for (r = rounds - 1; r > 1; --r) {
            temp0 = baux0 ^ keys[r][0];
            temp1 = baux1 ^ keys[r][1];
            temp2 = baux2 ^ keys[r][2];
            temp3 = baux3 ^ keys[r][3];
            baux0 = aestbl.T5[temp0 >>> 24] ^ aestbl.T6[temp3 >>> 16 & 0xFF] ^ aestbl.T7[temp2 >>> 8 & 0xFF] ^ aestbl.T8[temp1 & 0xFF];
            baux1 = aestbl.T5[temp1 >>> 24] ^ aestbl.T6[temp0 >>> 16 & 0xFF] ^ aestbl.T7[temp3 >>> 8 & 0xFF] ^ aestbl.T8[temp2 & 0xFF];
            baux2 = aestbl.T5[temp2 >>> 24] ^ aestbl.T6[temp1 >>> 16 & 0xFF] ^ aestbl.T7[temp0 >>> 8 & 0xFF] ^ aestbl.T8[temp3 & 0xFF];
            baux3 = aestbl.T5[temp3 >>> 24] ^ aestbl.T6[temp2 >>> 16 & 0xFF] ^ aestbl.T7[temp1 >>> 8 & 0xFF] ^ aestbl.T8[temp0 & 0xFF];
        }
        temp0 = baux0 ^ keys[1][0];
        temp1 = baux1 ^ keys[1][1];
        temp2 = baux2 ^ keys[1][2];
        temp3 = baux3 ^ keys[1][3];
        baux0 = aestbl.S5[temp0 >>> 24] << 24 | (aestbl.S5[temp3 >>> 16 & 0xFF] & 0xFF) << 16 | (aestbl.S5[temp2 >>> 8 & 0xFF] & 0xFF) << 8 | aestbl.S5[temp1 & 0xFF] & 0xFF;
        baux1 = aestbl.S5[temp1 >>> 24] << 24 | (aestbl.S5[temp0 >>> 16 & 0xFF] & 0xFF) << 16 | (aestbl.S5[temp3 >>> 8 & 0xFF] & 0xFF) << 8 | aestbl.S5[temp2 & 0xFF] & 0xFF;
        baux2 = aestbl.S5[temp2 >>> 24] << 24 | (aestbl.S5[temp1 >>> 16 & 0xFF] & 0xFF) << 16 | (aestbl.S5[temp0 >>> 8 & 0xFF] & 0xFF) << 8 | aestbl.S5[temp3 & 0xFF] & 0xFF;
        baux3 = aestbl.S5[temp3 >>> 24] << 24 | (aestbl.S5[temp2 >>> 16 & 0xFF] & 0xFF) << 16 | (aestbl.S5[temp1 >>> 8 & 0xFF] & 0xFF) << 8 | aestbl.S5[temp0 & 0xFF] & 0xFF;
        AesKernel.unqrunch(baux0 ^= keys[0][0], output, ooutput);
        AesKernel.unqrunch(baux1 ^= keys[0][1], output, ooutput + 4);
        AesKernel.unqrunch(baux2 ^= keys[0][2], output, ooutput + 8);
        AesKernel.unqrunch(baux3 ^= keys[0][3], output, ooutput + 12);
    }

    private static final int qrunch(byte[] b, int boffset) {
        return b[boffset] << 24 | (b[boffset + 1] & 0xFF) << 16 | (b[boffset + 2] & 0xFF) << 8 | b[boffset + 3] & 0xFF;
    }

    private static final void unqrunch(int value, byte[] b, int boffset) {
        b[boffset + 3] = (byte)(value & 0xFF);
        b[boffset + 2] = (byte)(value >>> 8 & 0xFF);
        b[boffset + 1] = (byte)(value >>> 16 & 0xFF);
        b[boffset] = (byte)(value >>> 24);
    }
}

