/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.common.utils;

import com.cryptomathic.common.utils.ByteArrays;
import java.util.ArrayList;
import java.util.List;

public class TagLengthValueBuilder {
    private List<byte[]> values = new ArrayList<byte[]>();

    public byte[] getValue() {
        return ByteArrays.concat((byte[][])this.values.toArray((T[])new byte[0][]));
    }

    private static void insertByte(byte[] byArray, int n, byte by) {
        byArray[n] = by;
    }

    private static void insertShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >> 8 & 0xFF);
        byArray[n++] = (byte)(s & 0xFF);
    }

    private static void insertInteger(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
    }

    private static void insertLong(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >> 56 & 0xFFL);
        byArray[n++] = (byte)(l >> 48 & 0xFFL);
        byArray[n++] = (byte)(l >> 40 & 0xFFL);
        byArray[n++] = (byte)(l >> 32 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
    }

    private static void insertBytes(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public void addByte(int n, byte by) {
        byte[] byArray = new byte[5];
        TagLengthValueBuilder.insertShort(byArray, 0, (short)n);
        TagLengthValueBuilder.insertShort(byArray, 2, (short)1);
        TagLengthValueBuilder.insertByte(byArray, 4, by);
        this.values.add(byArray);
    }

    public void addShort(int n, short s) {
        byte[] byArray = new byte[6];
        TagLengthValueBuilder.insertShort(byArray, 0, (short)n);
        TagLengthValueBuilder.insertShort(byArray, 2, (short)2);
        TagLengthValueBuilder.insertShort(byArray, 4, s);
        this.values.add(byArray);
    }

    public void addInteger(int n, int n2) {
        byte[] byArray = new byte[8];
        TagLengthValueBuilder.insertShort(byArray, 0, (short)n);
        TagLengthValueBuilder.insertShort(byArray, 2, (short)4);
        TagLengthValueBuilder.insertInteger(byArray, 4, n2);
        this.values.add(byArray);
    }

    public void addLong(int n, long l) {
        byte[] byArray = new byte[8];
        TagLengthValueBuilder.insertShort(byArray, 0, (short)n);
        TagLengthValueBuilder.insertShort(byArray, 2, (short)4);
        TagLengthValueBuilder.insertLong(byArray, 4, l);
        this.values.add(byArray);
    }

    public void addBytes(int n, byte[] byArray) {
        byte[] byArray2 = new byte[4 + byArray.length];
        TagLengthValueBuilder.insertShort(byArray2, 0, (short)n);
        TagLengthValueBuilder.insertShort(byArray2, 2, (short)byArray.length);
        TagLengthValueBuilder.insertBytes(byArray2, 4, byArray);
        this.values.add(byArray2);
    }

    public void addString(int n, String string, boolean bl) {
        int n2 = string.length() + (bl ? 1 : 0);
        byte[] byArray = new byte[4 + n2];
        TagLengthValueBuilder.insertShort(byArray, 0, (short)n);
        TagLengthValueBuilder.insertShort(byArray, 2, (short)n2);
        TagLengthValueBuilder.insertBytes(byArray, 4, string.getBytes());
        this.values.add(byArray);
    }
}

