/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.common.utils;

import com.cryptomathic.common.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static final byte[] readStreamAsBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        StreamUtils.readFullArrayFromStream(inputStream, byArray);
        return byArray;
    }

    public static final String readStreamAsString(InputStream inputStream) throws IOException {
        return FileUtils.readStreamAsString(inputStream, "UTF-8");
    }

    public static final String readStreamAsString(InputStream inputStream, String string) throws IOException {
        byte[] byArray = FileUtils.readStreamAsBytes(inputStream);
        return new String(byArray, string);
    }

    public static final byte[] readFileAsBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        StreamUtils.readFullArrayFromStream(fileInputStream, byArray);
        fileInputStream.close();
        return byArray;
    }

    public static final byte[] readFileAsBytes(String string) throws IOException {
        return FileUtils.readFileAsBytes(new File(string));
    }

    public static final String readFileAsString(String string) throws IOException {
        return FileUtils.readFileAsString(string, "UTF-8");
    }

    public static final String readFileAsString(String string, String string2) throws IOException {
        byte[] byArray = FileUtils.readFileAsBytes(string);
        return new String(byArray, string2);
    }

    public static final void saveFile(String string, String string2) throws IOException {
        FileUtils.saveFile(string, string2, "UTF-8");
    }

    public static final void saveFile(String string, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(string2.getBytes(string3));
        fileOutputStream.close();
    }

    public static final void saveFile(String string, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }
}

