/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.common.utils;

public class Base64 {
    private static final int BASE64_LINE_LENGTH = 80;
    private static final byte[] base64_lookup = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] base64_invlookup = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1};

    private Base64() {
    }

    public static String encode(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        int n4 = (n2 + 2) / 3 * 4;
        byte[] byArray2 = new byte[n4 += bl ? n2 * 4 / 3 / 80 : 0];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 <= n2 - 3) {
            n3 = (byArray[n5 + n] << 24 >>> 8) + (byArray[n5 + n + 1] << 24 >>> 16) + (byArray[n5 + n + 2] << 24 >>> 24);
            byArray2[n6] = base64_lookup[n3 >>> 18 & 0x3F];
            byArray2[n6 + 1] = base64_lookup[n3 >>> 12 & 0x3F];
            byArray2[n6 + 2] = base64_lookup[n3 >>> 6 & 0x3F];
            byArray2[n6 + 3] = base64_lookup[n3 & 0x3F];
            n5 += 3;
            n6 += 4;
            if (!bl || (n7 += 4) < 80) continue;
            byArray2[n6] = 10;
            ++n6;
            n7 = 0;
        }
        if (n5 == n2 - 1) {
            n3 = byArray[n5 + n] << 24 >>> 8;
            byArray2[n6] = base64_lookup[n3 >>> 18 & 0x3F];
            byArray2[n6 + 1] = base64_lookup[n3 >>> 12 & 0x3F];
            byArray2[n6 + 2] = 61;
            byArray2[n6 + 3] = 61;
            ++n5;
            n6 += 4;
        }
        if (n5 == n2 - 2) {
            n3 = (byArray[n5 + n] << 24 >>> 8) + (byArray[n5 + n + 1] << 24 >>> 16);
            byArray2[n6] = base64_lookup[n3 >>> 18 & 0x3F];
            byArray2[n6 + 1] = base64_lookup[n3 >>> 12 & 0x3F];
            byArray2[n6 + 2] = base64_lookup[n3 >>> 6 & 0x3F];
            byArray2[n6 + 3] = 61;
            n5 += 2;
            n6 += 4;
        }
        return new String(byArray2);
    }

    public static String encode(byte[] byArray, int n, int n2) {
        return Base64.encode(byArray, n, n2, true);
    }

    public static String encode(byte[] byArray, boolean bl) {
        return Base64.encode(byArray, 0, byArray.length, bl);
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 0, byArray.length, true);
    }

    public static byte[] decode(byte[] byArray, int n, int n2) throws Base64Exception {
        byte[] byArray2 = new byte[n2 * 3 / 4];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n3 < n2) {
            if (byArray[n3 + n] == 9 || byArray[n3 + n] == 32 || byArray[n3 + n] == 13 || byArray[n3 + n] == 10) {
                ++n3;
                continue;
            }
            if (byArray[n3 + n] == 61) {
                ++n3;
                if (bl) continue;
                if (n5 <= 1) {
                    throw new Base64Exception("Invalid Base64 (bad ending)");
                }
                if (n5 == 2) {
                    byArray2[n4] = (byte)(n6 >>> 4 & 0xFF);
                    ++n4;
                    bl = true;
                    continue;
                }
                byArray2[n4] = (byte)(n6 >>> 10 & 0xFF);
                byArray2[n4 + 1] = (byte)(n6 >>> 2 & 0xFF);
                n4 += 2;
                bl = true;
                continue;
            }
            if (bl) {
                throw new Base64Exception("Invalid Base64 (bad ending - non-'=' characters)");
            }
            if ((byArray[n3] & 0x80) != 0) {
                throw new Base64Exception("Invalid Base64 (invalic character :" + byArray[n4] + ")");
            }
            byte by = base64_invlookup[byArray[n3]];
            if (by == -1) {
                throw new Base64Exception("Invalid Base64 (invalic character :" + byArray[n4] + ")");
            }
            ++n3;
            n6 = n6 << 6 | by;
            if (++n5 != 4) continue;
            byArray2[n4] = (byte)(n6 >>> 16 & 0xFF);
            byArray2[n4 + 1] = (byte)(n6 >>> 8 & 0xFF);
            byArray2[n4 + 2] = (byte)(n6 & 0xFF);
            n4 += 3;
            n6 = 0;
            n5 = 0;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    public static byte[] decode(String string) throws Base64Exception {
        byte[] byArray = string.getBytes();
        return Base64.decode(byArray, 0, byArray.length);
    }

    public static class Base64Exception
    extends Exception {
        public Base64Exception(String string) {
            super(string);
        }
    }
}

