/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.X509;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BitString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.X509.Extensions;
import com.cryptomathic.X509.Name;
import com.cryptomathic.X509.SubjectPublicKeyInfo;
import com.cryptomathic.X509.Validity;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.PublicKey;
import java.util.Vector;

public class TBSCertificate
extends Sequence {
    public ASN1Integer version;
    public ASN1Integer serialNumber;
    public AlgorithmIdentifier signature;
    public Name issuer;
    public Validity validity;
    public Name subject;
    public SubjectPublicKeyInfo subjectPublicKeyInfo;
    public BitString issuerUniqueID;
    public BitString subjectUniqueID;
    public Extensions extensions;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.serialNumber = (ASN1Integer)v.get(1);
        this.signature = (AlgorithmIdentifier)v.get(2);
        this.issuer = (Name)v.get(3);
        this.validity = (Validity)v.get(4);
        this.subject = (Name)v.get(5);
        this.subjectPublicKeyInfo = (SubjectPublicKeyInfo)v.get(6);
        this.issuerUniqueID = (BitString)v.get(7);
        this.subjectUniqueID = (BitString)v.get(8);
        this.extensions = (Extensions)v.get(9);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(10);
        v.add(this.version);
        v.add(this.serialNumber);
        v.add(this.signature);
        v.add(this.issuer);
        v.add(this.validity);
        v.add(this.subject);
        v.add(this.subjectPublicKeyInfo);
        v.add(this.issuerUniqueID);
        v.add(this.subjectUniqueID);
        v.add(this.extensions);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addDefaultExplicitMember(new ASN1Integer(0), 0);
        template.addMember(ASN1Integer.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(Name.class);
        template.addMember(Validity.class);
        template.addMember(Name.class);
        template.addMember(SubjectPublicKeyInfo.class);
        template.addImplicitOptionalMember(BitString.class, 1);
        template.addImplicitOptionalMember(BitString.class, 2);
        template.addExplicitOptionalMember(Extensions.class, 3);
        return template;
    }

    public PublicKey getPublicKey() throws ASN1Exception {
        return this.subjectPublicKeyInfo.getKey();
    }
}

