/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.X509;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BMPString;
import com.cryptomathic.ASN1.Choice;
import com.cryptomathic.ASN1.ChoiceTemplate;
import com.cryptomathic.ASN1.IA5String;
import com.cryptomathic.ASN1.PrintableString;
import com.cryptomathic.ASN1.TeletexString;
import com.cryptomathic.ASN1.UTF8String;
import java.util.Vector;

public class DirectoryString
extends Choice {
    PrintableString printableString;
    BMPString bmpString;
    IA5String ia5String;
    TeletexString teletexString;
    UTF8String utf8String;

    public DirectoryString() {
    }

    public DirectoryString(String value) {
        if (PrintableString.isValid(value)) {
            this.printableString = new PrintableString(value);
        } else {
            this.utf8String = new UTF8String(value);
        }
    }

    protected void setMembers(Vector v) throws ASN1Exception {
        this.printableString = (PrintableString)v.get(0);
        this.bmpString = (BMPString)v.get(1);
        this.ia5String = (IA5String)v.get(2);
        this.teletexString = (TeletexString)v.get(3);
        this.utf8String = (UTF8String)v.get(4);
    }

    protected Vector getMembers() throws ASN1Exception {
        Vector<ASN1Object> v = new Vector<ASN1Object>(4);
        v.add(this.printableString);
        v.add(this.bmpString);
        v.add(this.ia5String);
        v.add(this.teletexString);
        v.add(this.utf8String);
        return v;
    }

    public ChoiceTemplate getTemplate() throws ASN1Exception {
        ChoiceTemplate template = new ChoiceTemplate();
        template.addMember(PrintableString.class);
        template.addMember(BMPString.class);
        template.addMember(IA5String.class);
        template.addMember(TeletexString.class);
        template.addMember(UTF8String.class);
        return template;
    }
}

