/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS8;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.PKCS1.RSAPrivateKey;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;

public class PrivateKeyInfo
extends Sequence {
    public ASN1Integer version;
    public AlgorithmIdentifier privateKeyAlgorithm;
    public OctetString privateKey;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.privateKeyAlgorithm = (AlgorithmIdentifier)v.get(1);
        this.privateKey = (OctetString)v.get(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.version);
        v.add(this.privateKeyAlgorithm);
        v.add(this.privateKey);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(OctetString.class);
        return template;
    }

    public PrivateKey getPrivateKey() throws InvalidKeySpecException, NoSuchAlgorithmException, ASN1Exception {
        if (this.privateKeyAlgorithm.algorithm.equals(OIDs.rsaEncryption)) {
            RSAPrivateKey rsaPrivateKey = new RSAPrivateKey();
            rsaPrivateKey.decode(this.privateKey.value);
            return rsaPrivateKey.getPrivateKey();
        }
        throw new ASN1Exception("Unknown privateKeyAlgorithm : " + this.privateKeyAlgorithm.toString());
    }

    public PublicKey getPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException, ASN1Exception {
        if (this.privateKeyAlgorithm.algorithm.equals(OIDs.rsaEncryption)) {
            RSAPrivateKey rsaPrivateKey = new RSAPrivateKey();
            rsaPrivateKey.decode(this.privateKey.value);
            return rsaPrivateKey.getPublicKey();
        }
        throw new ASN1Exception("Unknown privateKeyAlgorithm : " + this.privateKeyAlgorithm.toString());
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, ASN1Exception {
        if (privateKey instanceof java.security.interfaces.RSAPrivateKey) {
            if (this.version == null) {
                this.version = new ASN1Integer(0);
            }
        } else {
            throw new ASN1Exception("Unsupported keytype");
        }
        java.security.interfaces.RSAPrivateKey rsaPrivateKey = (java.security.interfaces.RSAPrivateKey)privateKey;
        this.privateKeyAlgorithm = AlgorithmIdentifier.makeAlgorithm("RSA");
        this.privateKey = new OctetString(RSAPrivateKey.makeFromPrivateKey(rsaPrivateKey).encode());
    }

    public static PrivateKeyInfo makeFromPrivateKey(PrivateKey privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, ASN1Exception {
        PrivateKeyInfo res = new PrivateKeyInfo();
        res.setPrivateKey(privateKey);
        return res;
    }
}

