/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import java.math.BigInteger;

public class PBKDFsha {
    public static final byte[] PBKDF(String password, byte[] salt, int id, int it_count, int dkLen) {
        byte[] asciiBytes = password.getBytes();
        byte[] unicodeBytes = new byte[asciiBytes.length * 2 + 2];
        for (int i = 0; i < asciiBytes.length; ++i) {
            unicodeBytes[2 * i] = 0;
            unicodeBytes[2 * i + 1] = asciiBytes[i];
        }
        unicodeBytes[asciiBytes.length * 2] = 0;
        unicodeBytes[asciiBytes.length * 2 + 1] = 0;
        return PBKDFsha.PBKDF(unicodeBytes, salt, id, it_count, dkLen);
    }

    public static final byte[] PBKDF(byte[] password, byte[] salt, int id, int it_count, int dkLen) {
        int u = 160;
        int v = 512;
        int n = dkLen * 8;
        if (id < 1 || id > 3) {
            throw new IllegalArgumentException("Invalid id");
        }
        byte[] D = new byte[v / 8];
        for (int i = 0; i < D.length; ++i) {
            D[i] = (byte)id;
        }
        byte[] S = PBKDFsha.mconcat(salt, v * ((salt.length * 8 + v - 1) / v) / 8);
        byte[] P = PBKDFsha.mconcat(password, v * ((password.length * 8 + v - 1) / v) / 8);
        byte[] I = new byte[S.length + P.length];
        System.arraycopy(S, 0, I, 0, S.length);
        System.arraycopy(P, 0, I, S.length, P.length);
        int c = (n + u - 1) / u;
        byte[] A = new byte[c * 20];
        for (int i = 0; i < c; ++i) {
            try {
                HashState _state = HashState.start_hash(HashType.SHA);
                _state.do_hash(D, 0, D.length);
                byte[] Ai = _state.stop_hash(HashPadMode.IMPPAD, I, 0, I.length);
                for (int j = 1; j < it_count; ++j) {
                    _state = HashState.start_hash(HashType.SHA);
                    Ai = _state.stop_hash(HashPadMode.IMPPAD, Ai, 0, Ai.length);
                }
                System.arraycopy(Ai, 0, A, i * 20, 20);
                byte[] B = PBKDFsha.mconcat(Ai, v / 8);
                I = PBKDFsha.modifyIbyB(I, B, v);
                continue;
            }
            catch (HashException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        if (A.length == dkLen) {
            return A;
        }
        byte[] temp = new byte[dkLen];
        System.arraycopy(A, 0, temp, 0, dkLen);
        return temp;
    }

    private static final byte[] mconcat(byte[] input, int bytes_in_output) {
        if (input == null || input.length == 0) {
            return new byte[0];
        }
        byte[] output = new byte[bytes_in_output];
        int i = 0;
        i = 0;
        while (i + input.length < output.length) {
            System.arraycopy(input, 0, output, i, input.length);
            i += input.length;
        }
        System.arraycopy(input, 0, output, i, output.length - i);
        return output;
    }

    private static final byte[] modifyIbyB(byte[] I, byte[] B, int v) {
        byte[] output = new byte[I.length];
        BigInteger two_v = new BigInteger("2");
        two_v = two_v.pow(v);
        BigInteger biB = new BigInteger(1, B);
        for (int i = 0; i < I.length; i += v / 8) {
            byte[] temp = new byte[v / 8];
            System.arraycopy(I, i, temp, 0, v / 8);
            BigInteger biI = new BigInteger(1, temp);
            biI = biI.add(biB).add(BigInteger.ONE).mod(two_v);
            temp = biI.toByteArray();
            if (temp.length > v / 8) {
                System.arraycopy(temp, temp.length - v / 8, output, i, v / 8);
                continue;
            }
            if (temp.length == v / 8) {
                System.arraycopy(temp, 0, output, i, temp.length);
                continue;
            }
            System.arraycopy(temp, 0, output, i + v / 8 - temp.length, temp.length);
        }
        return output;
    }
}

