/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.DigestInfo;
import com.cryptomathic.PKCS12.PBKDFsha;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.hash.HmacMech;
import com.cryptomathic.misc.AlgorithmIdentifier;
import com.cryptomathic.util.ByteArray;
import java.security.SecureRandom;
import java.util.Vector;

public class MacData
extends Sequence {
    public DigestInfo mac;
    public OctetString macSalt;
    public ASN1Integer iterations;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.mac = (DigestInfo)v.get(0);
        this.macSalt = (OctetString)v.get(1);
        this.iterations = (ASN1Integer)v.get(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.mac);
        v.add(this.macSalt);
        v.add(this.iterations);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(DigestInfo.class);
        template.addMember(OctetString.class);
        template.addDefaultMember(new ASN1Integer(1));
        return template;
    }

    protected byte[] calculateMac(byte[] data, String password) throws ASN1Exception, HashException {
        if (!this.mac.digestAlgorithm.algorithm.equals(OIDs.id_oiw_sha1)) {
            throw new ASN1Exception("PKCS#12 MacData only supports HMAC SHA-1");
        }
        int dkLen = 20;
        byte[] key = PBKDFsha.PBKDF(password, this.macSalt.value, 3, this.iterations.getInteger(), dkLen);
        byte[] hmac = HmacMech.hmac_mes(HashType.SHA, key, data, data.length);
        return hmac;
    }

    public void mac(byte[] data, String password, SecureRandom random, int iterations) throws ASN1Exception, HashException {
        this.mac.digestAlgorithm = new AlgorithmIdentifier();
        this.mac.digestAlgorithm.setAlgorithm("SHA1");
        this.macSalt = new OctetString(random.generateSeed(20));
        this.iterations = new ASN1Integer(iterations);
        this.calculateMac(data, password);
    }

    public void verify(byte[] data, String password) throws ASN1Exception, HashException {
        byte[] hmac = this.calculateMac(data, password);
        if (!ByteArray.equals(this.mac.digest.value, hmac)) {
            throw new ASN1Exception("HMAC verification failed");
        }
    }
}

