/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.AnyDefinedBy;
import com.cryptomathic.ASN1.AnyDefinedByTemplate;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.PKCS12.CertBag;
import com.cryptomathic.PKCS12.CertValue;
import com.cryptomathic.PKCS8.EncryptedPrivateKeyInfo;
import com.cryptomathic.PKCS8.PrivateKeyInfo;
import com.cryptomathic.X509.X509Certificate;

public class BagValue
extends AnyDefinedBy {
    public BagValue() {
    }

    public BagValue(ASN1Object obj) {
        super(obj);
    }

    protected AnyDefinedByTemplate getTemplate() {
        AnyDefinedByTemplate template = new AnyDefinedByTemplate();
        template.addMember(PrivateKeyInfo.class, OIDs.pkcs12_keyBag);
        template.addMember(EncryptedPrivateKeyInfo.class, OIDs.pkcs12_PKCS8ShroudedKeyBag);
        template.addMember(CertBag.class, OIDs.pkcs12_certBag);
        return template;
    }

    public void set(PrivateKeyInfo privateKeyInfo) {
        this.value = privateKeyInfo;
    }

    public void set(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.value = encryptedPrivateKeyInfo;
    }

    public void set(X509Certificate cert) {
        CertBag certBag = new CertBag();
        certBag.certId = new ObjectIdentifier(OIDs.pkcs12_x509Certificate);
        certBag.certValue = new CertValue(cert);
        this.value = cert;
    }
}

