/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Vector;

public class RSAPrivateKey
extends Sequence {
    public ASN1Integer version;
    public ASN1Integer modulus;
    public ASN1Integer publicExponent;
    public ASN1Integer privateExponent;
    public ASN1Integer prime1;
    public ASN1Integer prime2;
    public ASN1Integer exponent1;
    public ASN1Integer exponent2;
    public ASN1Integer coefficient;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.modulus = (ASN1Integer)v.get(1);
        this.publicExponent = (ASN1Integer)v.get(2);
        this.privateExponent = (ASN1Integer)v.get(3);
        this.prime1 = (ASN1Integer)v.get(4);
        this.prime2 = (ASN1Integer)v.get(5);
        this.exponent1 = (ASN1Integer)v.get(6);
        this.exponent2 = (ASN1Integer)v.get(7);
        this.coefficient = (ASN1Integer)v.get(8);
    }

    protected Vector getMembers() {
        Vector<ASN1Integer> v = new Vector<ASN1Integer>(9);
        v.add(this.version);
        v.add(this.modulus);
        v.add(this.publicExponent);
        v.add(this.privateExponent);
        v.add(this.prime1);
        v.add(this.prime2);
        v.add(this.exponent1);
        v.add(this.exponent2);
        v.add(this.coefficient);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        template.addMember(ASN1Integer.class);
        return template;
    }

    public PublicKey getPublicKey() throws ASN1Exception, InvalidKeySpecException, NoSuchAlgorithmException {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(this.modulus.getBigInteger(), this.publicExponent.getBigInteger());
        return KeyFactory.getInstance("RSA").generatePublic(keySpec);
    }

    public PrivateKey getPrivateKey() throws ASN1Exception, InvalidKeySpecException, NoSuchAlgorithmException {
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(this.modulus.getBigInteger(), this.publicExponent.getBigInteger(), this.privateExponent.getBigInteger(), this.prime1.getBigInteger(), this.prime2.getBigInteger(), this.exponent1.getBigInteger(), this.exponent2.getBigInteger(), this.coefficient.getBigInteger());
        return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }

    public void setPrivateKey(java.security.interfaces.RSAPrivateKey privateKey) throws ASN1Exception, InvalidKeySpecException, NoSuchAlgorithmException {
        RSAPrivateCrtKey crtKey;
        if (privateKey instanceof RSAPrivateCrtKey) {
            crtKey = (RSAPrivateCrtKey)privateKey;
            if (this.version == null) {
                this.version = new ASN1Integer(0);
            }
        } else {
            throw new ASN1Exception("Only CRT keys are supported");
        }
        this.modulus = new ASN1Integer(crtKey.getModulus());
        this.publicExponent = new ASN1Integer(crtKey.getPublicExponent());
        this.privateExponent = new ASN1Integer(crtKey.getPrivateExponent());
        this.prime1 = new ASN1Integer(crtKey.getPrimeP());
        this.prime2 = new ASN1Integer(crtKey.getPrimeQ());
        this.exponent1 = new ASN1Integer(crtKey.getPrimeExponentP());
        this.exponent2 = new ASN1Integer(crtKey.getPrimeExponentQ());
        this.coefficient = new ASN1Integer(crtKey.getCrtCoefficient());
    }

    public static RSAPrivateKey makeFromPrivateKey(java.security.interfaces.RSAPrivateKey privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, ASN1Exception {
        RSAPrivateKey res = new RSAPrivateKey();
        res.setPrivateKey(privateKey);
        return res;
    }
}

