/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.OCSP;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashMech;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.util.Vector;

public class CertID
extends Sequence {
    public AlgorithmIdentifier hashAlgorithm;
    public OctetString issuerNameHash;
    public OctetString issuerKeyHash;
    public ASN1Integer serialNumber;

    public void setFromCertificates(X509Certificate X509Cert, HashType hashAlg, byte[] issKeyHash) throws ASN1Exception, HashException {
        byte[] mes = X509Cert.tbsCertificate.issuer.encode();
        this.hashAlgorithm = new AlgorithmIdentifier();
        this.hashAlgorithm.setAlgorithm(hashAlg.toString());
        this.issuerNameHash = new OctetString(HashMech.hash_mes(hashAlg, HashPadMode.NOPAD, mes, mes.length));
        this.issuerKeyHash = new OctetString(issKeyHash);
        this.serialNumber = X509Cert.tbsCertificate.serialNumber;
    }

    protected void setMembers(Vector v) throws ASN1Exception {
        this.hashAlgorithm = (AlgorithmIdentifier)v.get(0);
        this.issuerNameHash = (OctetString)v.get(1);
        this.issuerKeyHash = (OctetString)v.get(2);
        this.serialNumber = (ASN1Integer)v.get(3);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(4);
        v.add(this.hashAlgorithm);
        v.add(this.issuerNameHash);
        v.add(this.issuerKeyHash);
        v.add(this.serialNumber);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(OctetString.class);
        template.addMember(OctetString.class);
        template.addMember(ASN1Integer.class);
        return template;
    }
}

