/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CRL;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BitString;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.X509.TBSCertList;
import com.cryptomathic.crypto.rsa.Pkcs1v1;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;

public class CertificateList
extends Sequence {
    public TBSCertList tbsCertList;
    public AlgorithmIdentifier signatureAlgorithm;
    public BitString signature;

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.tbsCertList);
        v.add(this.signatureAlgorithm);
        v.add(this.signature);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(TBSCertList.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(BitString.class);
        return template;
    }

    protected void setMembers(Vector v) throws ASN1Exception {
        this.tbsCertList = (TBSCertList)v.get(0);
        this.signatureAlgorithm = (AlgorithmIdentifier)v.get(1);
        this.signature = (BitString)v.get(2);
    }

    public boolean Verify(PublicKey issuerPublicKey) throws ASN1Exception {
        if (this.signatureAlgorithm.algorithm.equals(OIDs.sha1withRSAEncryption) || this.signatureAlgorithm.algorithm.equals(OIDs.md5withRSAEncryption)) {
            return Pkcs1v1.verify((RSAPublicKey)issuerPublicKey, this.tbsCertList.encode(), this.signature.value);
        }
        throw new ASN1Exception("Unknown signature algorithm used to sign certificate: " + this.signatureAlgorithm.algorithm.toString());
    }
}

