/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.SignerIdentifier;
import com.cryptomathic.PKCS9.Attribute;
import com.cryptomathic.PKCS9.Attributes;
import com.cryptomathic.PKCS9.SetOfObjectIdentifier;
import com.cryptomathic.PKCS9.SetOfOctetString;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.rsa.Pkcs1v1;
import com.cryptomathic.misc.AlgorithmIdentifier;
import com.cryptomathic.util.ByteArray;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;

public class SignerInfo
extends Sequence {
    public ASN1Integer version;
    public SignerIdentifier sid;
    public AlgorithmIdentifier digestAlgorithm;
    public Attributes signedAttrs;
    public AlgorithmIdentifier signatureAlgorithm;
    public OctetString signatureValue;
    public Attributes unsignedAttrs;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.sid = (SignerIdentifier)v.get(1);
        this.digestAlgorithm = (AlgorithmIdentifier)v.get(2);
        this.signedAttrs = (Attributes)v.get(3);
        this.signatureAlgorithm = (AlgorithmIdentifier)v.get(4);
        this.signatureValue = (OctetString)v.get(5);
        this.unsignedAttrs = (Attributes)v.get(6);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(7);
        v.add(this.version);
        v.add(this.sid);
        v.add(this.digestAlgorithm);
        v.add(this.signedAttrs);
        v.add(this.signatureAlgorithm);
        v.add(this.signatureValue);
        v.add(this.unsignedAttrs);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(SignerIdentifier.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addImplicitOptionalMember(Attributes.class, 0);
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(OctetString.class);
        template.addImplicitOptionalMember(Attributes.class, 0);
        return template;
    }

    public void setMessageDigestAttribute(OctetString digestValue) throws ASN1Exception {
        if (this.signedAttrs == null) {
            this.signedAttrs = new Attributes();
        }
        Attribute attr = new Attribute(new ObjectIdentifier(OIDs.pkcs9_messageDigest), digestValue);
        this.signedAttrs.add(attr);
    }

    public void setContentTypeAttribute(ObjectIdentifier pContentType) throws ASN1Exception {
        if (this.signedAttrs == null) {
            this.signedAttrs = new Attributes();
        }
        Attribute attr = new Attribute(new ObjectIdentifier(OIDs.pkcs9_contentType), pContentType);
        this.signedAttrs.add(attr);
    }

    public byte[] getEncodedSignedAttributes() throws ASN1Exception {
        byte[] enc = this.signedAttrs.encode();
        enc[0] = 49;
        return enc;
    }

    public void setSignerIdentifier(X509Certificate cert) {
        if (this.sid == null) {
            this.sid = new SignerIdentifier();
        }
        this.sid.set(cert);
    }

    public void setAlgorithms(String algorithm) throws ASN1Exception {
        this.setDigestAlgorithm(algorithm);
        this.setSignatureAlgorithm(algorithm);
    }

    public void setDigestAlgorithm(String algorithm) throws ASN1Exception {
        if (this.digestAlgorithm == null) {
            this.digestAlgorithm = new AlgorithmIdentifier();
        }
        this.digestAlgorithm.setDigestAlgorithm(algorithm);
    }

    public void setSignatureAlgorithm(String algorithm) throws ASN1Exception {
        if (this.signatureAlgorithm == null) {
            this.signatureAlgorithm = new AlgorithmIdentifier();
        }
        this.signatureAlgorithm.setSignatureAlgorithm(algorithm);
    }

    public void sign(PrivateKey privateKey, String algorithm, ObjectIdentifier contentType, byte[] content) throws ASN1Exception, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, HashException {
        byte[] finalContent;
        if (this.signedAttrs != null || !contentType.value.equals(OIDs.pkcs7_data)) {
            if (this.signedAttrs == null) {
                this.signedAttrs = new Attributes();
            }
            this.version = new ASN1Integer(2);
            this.setContentTypeAttribute(contentType);
            byte[] hash = this.digestAlgorithm.Hash(content);
            this.setMessageDigestAttribute(new OctetString(hash));
            finalContent = this.getEncodedSignedAttributes();
        } else {
            finalContent = content;
        }
        this.setAlgorithms(algorithm);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(privateKey);
        signature.update(finalContent);
        this.signatureValue = new OctetString();
        this.signatureValue.value = signature.sign();
    }

    public boolean verify(PublicKey publicKey, ObjectIdentifier contentType, byte[] content) throws ASN1Exception, GeneralSecurityException, HashException {
        byte[] finalContent;
        if (this.signedAttrs == null && !contentType.equals(OIDs.pkcs7_data)) {
            return false;
        }
        if (this.signedAttrs != null || !contentType.equals(OIDs.pkcs7_data)) {
            if (!contentType.equals(this.getContentTypeAttribute())) {
                return false;
            }
            byte[] hash = this.digestAlgorithm.Hash(content);
            if (!ByteArray.equals(hash, this.getMessageDigestAttribute())) {
                return false;
            }
            finalContent = this.getEncodedSignedAttributes();
        } else {
            finalContent = content;
        }
        boolean ok = Pkcs1v1.verify((RSAPublicKey)publicKey, finalContent, this.signatureValue.value);
        return ok;
    }

    public ObjectIdentifier getContentTypeAttribute() throws ASN1Exception {
        if (this.signedAttrs == null) {
            return null;
        }
        Attribute attr = this.signedAttrs.findFirst(OIDs.pkcs9_contentType);
        if (attr == null) {
            return null;
        }
        SetOfObjectIdentifier SOObjId = (SetOfObjectIdentifier)attr.attrValues.value;
        if (SOObjId.size() != 1) {
            throw new ASN1Exception("ContentTypeAttribute had more than one value");
        }
        return SOObjId.get(0);
    }

    public byte[] getMessageDigestAttribute() throws ASN1Exception {
        if (this.signedAttrs == null) {
            return null;
        }
        Attribute attr = this.signedAttrs.findFirst(OIDs.pkcs9_messageDigest);
        if (attr == null) {
            return null;
        }
        SetOfOctetString SOOctetString = (SetOfOctetString)attr.attrValues.value;
        if (SOOctetString.size() != 1) {
            throw new ASN1Exception("MessageDigestAttribute had more than one value");
        }
        return SOOctetString.get((int)0).value;
    }
}

