/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.CertificateRevocationLists;
import com.cryptomathic.CMS.EncapsulatedContentInfo;
import com.cryptomathic.CMS.SignerInfo;
import com.cryptomathic.CMS.SignerInfos;
import com.cryptomathic.CRL.CertificateList;
import com.cryptomathic.X509.CertificateSet;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.misc.AlgorithmIdentifier;
import com.cryptomathic.misc.AlgorithmIdentifiers;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Vector;

public class SignedData
extends Sequence {
    public ASN1Integer version;
    public AlgorithmIdentifiers digestAlgorithms;
    public EncapsulatedContentInfo encapContentInfo;
    public CertificateSet certificates;
    public CertificateRevocationLists crls;
    public SignerInfos signerInfos;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.digestAlgorithms = (AlgorithmIdentifiers)v.get(1);
        this.encapContentInfo = (EncapsulatedContentInfo)v.get(2);
        this.certificates = (CertificateSet)v.get(3);
        this.crls = (CertificateRevocationLists)v.get(4);
        this.signerInfos = (SignerInfos)v.get(5);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(6);
        v.add(this.version);
        v.add(this.digestAlgorithms);
        v.add(this.encapContentInfo);
        v.add(this.certificates);
        v.add(this.crls);
        v.add(this.signerInfos);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(AlgorithmIdentifiers.class);
        template.addMember(EncapsulatedContentInfo.class);
        template.addImplicitOptionalMember(CertificateSet.class, 0);
        template.addImplicitOptionalMember(CertificateRevocationLists.class, 1);
        template.addMember(SignerInfos.class);
        return template;
    }

    public void Sign(PrivateKey privateKey, X509Certificate cert, String algorithm, ObjectIdentifier contentType, byte[] content) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, ASN1Exception, HashException {
        if (this.signerInfos == null) {
            this.signerInfos = new SignerInfos();
        }
        SignerInfo signerInfo = new SignerInfo();
        signerInfo.version = new ASN1Integer(0);
        signerInfo.setSignerIdentifier(cert);
        signerInfo.sign(privateKey, algorithm, contentType, content);
        this.signerInfos.add(signerInfo);
        if (this.digestAlgorithms == null) {
            this.digestAlgorithms = new AlgorithmIdentifiers();
        }
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier();
        digestAlg.setDigestAlgorithm(algorithm);
        this.digestAlgorithms.add(digestAlg);
        if (this.encapContentInfo == null) {
            this.encapContentInfo = new EncapsulatedContentInfo();
        }
        this.encapContentInfo.eContentType = contentType;
        this.encapContentInfo.eContent = new OctetString(content);
        this.addCertificate(cert);
    }

    public void setContent(byte[] content, ObjectIdentifier contentType) {
        if (this.encapContentInfo == null) {
            this.encapContentInfo = new EncapsulatedContentInfo();
        }
        this.encapContentInfo.set(content, contentType);
    }

    public void setContent(byte[] content) {
        if (this.encapContentInfo == null) {
            this.encapContentInfo = new EncapsulatedContentInfo();
        }
        this.encapContentInfo.set(content);
    }

    public void setVersion(int v) {
        if (this.version == null) {
            this.version = new ASN1Integer();
        }
        this.version.set(v);
    }

    public void addCertificate(X509Certificate cert) {
        if (this.certificates == null) {
            this.certificates = new CertificateSet();
        }
        this.certificates.add(cert);
    }

    public void addCRL(CertificateList CRL) {
        if (this.crls == null) {
            this.crls = new CertificateRevocationLists();
        }
        this.crls.add(CRL);
    }

    public void addSignerInfo(SignerInfo signerInfo) {
        if (this.signerInfos == null) {
            this.signerInfos = new SignerInfos();
        }
        this.signerInfos.add(signerInfo);
    }

    public void addCertificates(X509Certificate[] otherCerts) {
        if (this.certificates == null) {
            this.certificates = new CertificateSet();
        }
        for (int i = 0; i < otherCerts.length; ++i) {
            this.certificates.add(otherCerts[i]);
        }
    }
}

