/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.EncryptedContentInfo;
import com.cryptomathic.PKCS9.Attributes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EncryptedData
extends Sequence {
    public ASN1Integer version;
    public EncryptedContentInfo encryptedContentInfo;
    public Attributes unprotectedAttrs;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.encryptedContentInfo = (EncryptedContentInfo)v.get(1);
        this.unprotectedAttrs = (Attributes)v.get(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.version);
        v.add(this.encryptedContentInfo);
        v.add(this.unprotectedAttrs);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(EncryptedContentInfo.class);
        template.addImplicitOptionalMember(Attributes.class, 1);
        return template;
    }

    public void encrypt(byte[] key, String alg, AlgorithmParameterSpec params, byte[] data) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.encryptedContentInfo == null) {
            this.encryptedContentInfo = new EncryptedContentInfo();
        }
        this.encryptedContentInfo.encrypt(key, alg, params, data);
    }

    public byte[] decrypt(String password) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        return this.encryptedContentInfo.decrypt(password);
    }
}

