/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1ConstructedObject;
import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SequenceOf
extends ASN1ConstructedObject {
    protected Vector V = new Vector();

    public byte getTag() {
        return 48;
    }

    protected void add(ASN1Object obj) {
        this.V.add(obj);
    }

    public int size() {
        return this.V.size();
    }

    public ASN1Object get(int i) {
        return (ASN1Object)this.V.elementAt(i);
    }

    protected abstract Class getMemberClass();

    public void decodeValue(int tag, byte[] in) throws ASN1Exception {
        ByteArrayInputStream thisinput = new ByteArrayInputStream(in);
        Class thisclass = this.getMemberClass();
        while (thisinput.available() > 0) {
            ASN1Object obj;
            try {
                obj = (ASN1Object)thisclass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ASN1Exception("SequenceOf contained member (" + e.getMessage() + ")");
            }
            catch (IllegalAccessException e) {
                throw new ASN1Exception("SequenceOf contained member (" + e.getMessage() + ")");
            }
            try {
                obj.decode(thisinput);
            }
            catch (IOException e) {
                throw new ASN1Exception("Could not read from ByteArrayInputStream: " + e.getMessage());
            }
            this.add(obj);
        }
    }

    public void decodeValueIndefiniteLength(int tag, InputStream in) throws ASN1Exception {
        Class thisclass = this.getMemberClass();
        try {
            int readtag = in.read();
            while (readtag != 0) {
                ASN1Object obj;
                try {
                    obj = (ASN1Object)thisclass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ASN1Exception("SequenceOf contained member (" + e.getMessage() + ")");
                }
                catch (IllegalAccessException e) {
                    throw new ASN1Exception("SequenceOf contained member (" + e.getMessage() + ")");
                }
                boolean ok = obj.checkTag(readtag);
                if (!ok) {
                    throw new ASN1Exception("Bad tag in " + this.getClass().getName());
                }
                int length = SequenceOf.getLength(in);
                if (length == -1) {
                    obj.decodeValueIndefiniteLength(tag, in);
                } else {
                    int res;
                    byte[] encodedvalue = new byte[length];
                    if (length != 0 && (res = in.read(encodedvalue)) != length) {
                        throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
                    }
                    obj.decodeValue(tag, encodedvalue);
                }
                this.add(obj);
                readtag = in.read();
            }
        }
        catch (IOException e1) {
            throw new ASN1Exception("IOException" + e1.getMessage());
        }
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        Enumeration enumerator = this.V.elements();
        while (enumerator.hasMoreElements()) {
            ASN1Object obj = (ASN1Object)enumerator.nextElement();
            obj.encode(out);
        }
    }

    public String toString() {
        String result = "{";
        Enumeration enumObjs = this.V.elements();
        Object obj = enumObjs.nextElement();
        result = result + (obj != null ? obj.toString() : "--empty--");
        while (enumObjs.hasMoreElements()) {
            result = result + ", ";
            obj = enumObjs.nextElement();
            result = result + (obj != null ? obj.toString() : "--empty--");
        }
        result = result + "}";
        return result;
    }
}

