/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.misc.AlgorithmIdentifier;
import com.cryptomathic.util.ByteArray;
import java.util.HashMap;
import java.util.Map;

public class OIDs {
    public static final byte[] rsaEncryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    public static final byte[] sha1withRSAEncryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 5};
    public static final byte[] md5withRSAEncryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 4};
    public static final byte[] id_md5 = new byte[]{42, -122, 72, -122, -9, 13, 2, 5};
    public static final byte[] id_dsa = new byte[]{42, -122, 72, -50, 56, 4, 1};
    public static final byte[] dsaWithSha1 = new byte[]{42, -122, 72, -50, 56, 4, 3};
    public static final byte[] id_oiw_sha1withRSAEncryption = new byte[]{43, 14, 3, 2, 29};
    public static final byte[] sha256withRSAEncryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 11};
    public static final byte[] id_at_commonName = new byte[]{85, 4, 3};
    public static final byte[] id_at_surname = new byte[]{85, 4, 4};
    public static final byte[] id_at_serialNumber = new byte[]{85, 4, 5};
    public static final byte[] id_at_countryName = new byte[]{85, 4, 6};
    public static final byte[] id_at_localityName = new byte[]{85, 4, 7};
    public static final byte[] id_at_stateOrProvinceName = new byte[]{85, 4, 8};
    public static final byte[] id_at_organizationName = new byte[]{85, 4, 10};
    public static final byte[] id_at_organizationalUnitName = new byte[]{85, 4, 11};
    public static final byte[] id_at_title = new byte[]{85, 4, 12};
    public static final byte[] id_at_postalAddress = new byte[]{85, 4, 16};
    public static final byte[] id_at_name = new byte[]{85, 4, 41};
    public static final byte[] id_at_givenName = new byte[]{85, 4, 42};
    public static final byte[] id_at_initials = new byte[]{85, 4, 43};
    public static final byte[] id_at_generationQualifier = new byte[]{85, 4, 44};
    public static final byte[] id_at_pseudonym = new byte[]{85, 4, 65};
    public static final byte[] id_at_dnQualifier = new byte[]{85, 4, 46};
    public static final byte[] pkcs9_emailAddress = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    public static final byte[] id_oiw_sha1 = new byte[]{43, 14, 3, 2, 26};
    public static final byte[] id_nist_sha256 = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 1};
    public static final byte[] id_nist_sha384 = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 2};
    public static final byte[] id_nist_sha512 = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 3};
    public static final byte[] id_ripemd160 = new byte[]{43, 36, 3, 2, 1};
    public static final byte[] pkcs7_data = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
    public static final byte[] pkcs7_signedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 2};
    public static final byte[] pkcs7_encryptedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 6};
    public static final byte[] pkcs7_envelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 3};
    public static final byte[] tst_signingTime = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 5};
    public static final byte[] id_smime_ct_tstinfo = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 1, 4};
    public static final byte[] id_qt_cps = new byte[]{43, 6, 1, 5, 5, 7, 2, 1};
    public static final byte[] id_qt_unotice = new byte[]{43, 6, 1, 5, 5, 7, 2, 2};
    public static final byte[] id_aa_signingCertificate = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 2, 12};
    public static final byte[] pkcs12_keyBag = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 1};
    public static final byte[] pkcs12_PKCS8ShroudedKeyBag = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 2};
    public static final byte[] pkcs12_certBag = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 3};
    public static final byte[] pkcs12_crlBag = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 4};
    public static final byte[] pkcs12_secretBag = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 5};
    public static final byte[] pkcs12_safeContentsBag = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 6};
    public static final byte[] pkcs12_x509Certificate = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 22, 1};
    public static final byte[] pkcs9_contentType = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 3};
    public static final byte[] pkcs9_messageDigest = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 4};
    public static final byte[] pbeWithMD5AndDES_CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 3};
    public static final byte[] pbeWithSHAAnd3_KeyTripleDES_CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 1, 3};
    public static final byte[] pbeWithSHAAnd2_KeyTripleDES_CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 1, 4};
    public static final byte[] pbeWithSHAAnd40BitRC2_CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 1, 6};
    public static final byte[] pkcs12_friendlyName = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 20};
    public static final byte[] pkcs12_localKeyId = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 21};
    public static final byte[] ms_providerName = new byte[]{43, 6, 1, 4, 1, -126, 55, 17, 1};
    public static final byte[] RFC2560_ocspBasic = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 1};
    public static final byte[] RFC2560_ocspNonce = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 2};
    public static final byte[] id_characteristic_two_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3};
    public static final byte[] prime_field = new byte[]{42, -122, 72, -50, 61, 1, 1};
    public static final byte[] characteristic_two_field = new byte[]{42, -122, 72, -50, 61, 1, 2};
    public static final byte[] tp_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 2};
    public static final byte[] pp_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 3};
    public static final byte[] id_publicKeyType = new byte[]{42, -122, 72, -50, 61, 2};
    public static final byte[] id_ecPublicKey = new byte[]{42, -122, 72, -50, 61, 2, 1};
    public static final byte[] oiw_des_cbc = new byte[]{43, 14, 3, 2, 7};
    public static final byte[] id_des_ede3_cbc = new byte[]{42, -122, 72, -122, -9, 13, 3, 7};
    private static Map algObjectIdentifier2String = new HashMap();

    public static final String OID2AlgString(byte[] oid) throws ASN1Exception {
        Object obj = algObjectIdentifier2String.get(new ByteArray(oid));
        if (obj == null) {
            obj = ObjectIdentifier.toString(oid);
        }
        return (String)obj;
    }

    public static String AlgorithmPairToAlgString(AlgorithmIdentifier digestAlgorithm, AlgorithmIdentifier signatureAlgorithm) {
        return OIDs.AlgorithmPairToAlgString(digestAlgorithm.algorithm, signatureAlgorithm.algorithm);
    }

    public static String AlgorithmPairToAlgString(ObjectIdentifier digestAlgorithm, ObjectIdentifier signatureAlgorithm) {
        return OIDs.AlgorithmPairToAlgString(digestAlgorithm.value, signatureAlgorithm.value);
    }

    public static String AlgorithmPairToAlgString(byte[] digestAlgorithm, byte[] signatureAlgorithm) {
        if (ByteArray.equals(digestAlgorithm, id_oiw_sha1) && ByteArray.equals(signatureAlgorithm, rsaEncryption)) {
            return "SHA1/RSA";
        }
        if (ByteArray.equals(digestAlgorithm, id_nist_sha256) && ByteArray.equals(signatureAlgorithm, rsaEncryption)) {
            return "SHA256/RSA";
        }
        if (ByteArray.equals(digestAlgorithm, id_md5) && ByteArray.equals(signatureAlgorithm, rsaEncryption)) {
            return "MD5/RSA";
        }
        return "";
    }

    static {
        algObjectIdentifier2String.put(new ByteArray(sha1withRSAEncryption), "SHA1/RSA");
        algObjectIdentifier2String.put(new ByteArray(md5withRSAEncryption), "MD5/RSA");
        algObjectIdentifier2String.put(new ByteArray(rsaEncryption), "RSA");
        algObjectIdentifier2String.put(new ByteArray(id_oiw_sha1), "SHA1");
        algObjectIdentifier2String.put(new ByteArray(id_md5), "MD5");
        algObjectIdentifier2String.put(new ByteArray(id_nist_sha256), "SHA256");
        algObjectIdentifier2String.put(new ByteArray(id_nist_sha384), "SHA384");
        algObjectIdentifier2String.put(new ByteArray(id_nist_sha512), "SHA512");
        algObjectIdentifier2String.put(new ByteArray(id_ripemd160), "RIPEMD160");
        algObjectIdentifier2String.put(new ByteArray(pbeWithSHAAnd40BitRC2_CBC), "PBE/PKCS5");
        algObjectIdentifier2String.put(new ByteArray(oiw_des_cbc), "DES/CBC");
        algObjectIdentifier2String.put(new ByteArray(id_des_ede3_cbc), "DESede/CBC");
    }
}

