/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1NonStringObject;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GeneralizedTime
extends ASN1NonStringObject {
    public String value;

    public byte getTag() {
        return 24;
    }

    public GeneralizedTime() {
    }

    public GeneralizedTime(String val) {
        this.value = val;
    }

    public void decodeValue(int tag, byte[] enc) throws ASN1Exception {
        this.value = new String(enc);
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        out.write(this.value.getBytes());
    }

    public String toString() {
        return this.value;
    }

    public boolean checkDER() throws ASN1Exception {
        if (!this.value.endsWith("Z")) {
            throw new ASN1Exception("GeneralizedTime does not end with Z");
        }
        if (this.value.endsWith(".Z")) {
            throw new ASN1Exception("GeneralizedTime must not end with .Z");
        }
        return true;
    }

    public boolean before(GeneralizedTime then) throws ParseException {
        Date d2;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date d1 = df.parse(this.value);
        boolean b = d1.after(d2 = df.parse(then.value));
        return !b;
    }
}

