/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1StringObject;
import com.cryptomathic.util.ByteArray;
import java.io.IOException;
import java.io.OutputStream;

public class BitString
extends ASN1StringObject {
    public byte[] value;

    public byte getTag() {
        return 3;
    }

    public BitString() {
    }

    public BitString(byte[] val) {
        this.value = val;
    }

    public BitString(byte[] val, int unusedbits) {
        this.value = new byte[val.length + 1];
        this.value[0] = (byte)unusedbits;
        System.arraycopy(val, 0, this.value, 1, val.length);
    }

    public void appendValue(byte[] enc) throws ASN1Exception {
        if (this.value == null) {
            this.value = new byte[enc.length];
            System.arraycopy(enc, 0, this.value, 0, enc.length);
        } else {
            byte[] newvalue = new byte[this.value.length + enc.length];
            System.arraycopy(this.value, 0, newvalue, 0, this.value.length);
            System.arraycopy(enc, 0, newvalue, this.value.length, enc.length);
            this.value = newvalue;
        }
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        out.write(this.value);
    }

    public String toString() {
        return ByteArray.toString(this.value);
    }

    public byte[] getAsByteString() throws ASN1Exception {
        if (this.value[0] != 0) {
            throw new ASN1Exception("BitString did not contain a multiplum of 8 bits");
        }
        byte[] bytestring = new byte[this.value.length - 1];
        System.arraycopy(this.value, 1, bytestring, 0, this.value.length - 1);
        return bytestring;
    }
}

