/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.AnyDefinedByTemplate;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.util.ByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AnyDefinedBy
extends ASN1Object {
    private ObjectIdentifier objid;
    public ASN1Object value;

    public boolean checkTag(int tag) {
        return tag != -1;
    }

    public boolean checkExplicitTag(int tag, int number) throws ASN1Exception {
        return tag != -1;
    }

    public boolean checkImplicitTag(int tag, int number) throws ASN1Exception {
        return tag != -1;
    }

    public byte getTag() throws ASN1Exception {
        if (this.value == null) {
            throw new ASN1Exception("Called getTag on empty AnyDefinedBy");
        }
        return this.value.getTag();
    }

    public byte getExplicitTag(int number) throws ASN1Exception {
        if (this.value == null) {
            throw new ASN1Exception("Called getExplicitTag on empty AnyDefinedBy");
        }
        return this.value.getExplicitTag(number);
    }

    public byte getImplicitTag(int number) throws ASN1Exception {
        if (this.value == null) {
            throw new ASN1Exception("Called getImplicitTag on empty AnyDefinedBy");
        }
        return this.value.getImplicitTag(number);
    }

    public ASN1Object getValue() {
        return this.value;
    }

    public ObjectIdentifier getObjId() {
        return this.objid;
    }

    protected abstract AnyDefinedByTemplate getTemplate();

    public AnyDefinedBy() {
    }

    protected AnyDefinedBy(ASN1Object obj) {
        this.value = obj;
    }

    public void setAnyDefinedBy(ObjectIdentifier definedby) throws ASN1Exception {
        try {
            Class clazz = this.getTemplate().getClazz(definedby.value);
            if (clazz == null) {
                throw new ASN1Exception(this.getClass().getName() + " was defined by oid : " + definedby.toString() + " (" + ByteArray.toString(definedby.value) + ") which was not in template");
            }
            this.value = (ASN1Object)this.getTemplate().getClazz(definedby.value).newInstance();
        }
        catch (InstantiationException e) {
            throw new ASN1Exception("AnyDefinedBy contained invalid submember (" + e.getMessage() + ")");
        }
        catch (IllegalAccessException e) {
            throw new ASN1Exception("AnyDefinedBy contained invalid submember (" + e.getMessage() + ")");
        }
        this.objid = definedby;
    }

    public void setAnyDefinedBy(byte[] definedby) throws ASN1Exception {
        this.setAnyDefinedBy(new ObjectIdentifier(definedby));
    }

    public void decode(InputStream in) throws ASN1Exception, IOException {
        if (this.value == null) {
            throw new ASN1Exception("Called decode on uninitalized AnyDefinedBy");
        }
        this.value.decode(in);
    }

    public void decodeValue(int tag, byte[] enc) throws ASN1Exception {
        if (this.value == null) {
            throw new ASN1Exception("Called decodeValue on uninitalized AnyDefinedBy");
        }
        this.value.decodeValue(tag, enc);
    }

    public void decodeValueIndefiniteLength(int tag, InputStream in) throws ASN1Exception {
        if (this.value == null) {
            throw new ASN1Exception("Called decodeValue on uninitalized AnyDefinedBy");
        }
        this.value.decodeValueIndefiniteLength(tag, in);
    }

    public void encode(OutputStream out) throws ASN1Exception, IOException {
        if (this.value == null) {
            throw new ASN1Exception("Attempted to encode empty AnyDefinedBy");
        }
        this.value.encode(out);
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        if (this.value == null) {
            throw new ASN1Exception("Attempted to encode empty AnyDefinedBy");
        }
        this.value.encodeValue(out);
    }

    public String toString() {
        return this.value == null ? "--empty--" : this.value.toString();
    }
}

